/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterVisitor;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;

class PathVisitor
extends FilterVisitor {
    PathVisitor() {
    }

    @Override
    public void visit(HawkularPipeline<?, ?> query, Related<? extends Entity> related) {
        switch (related.getEntityRole()) {
            case TARGET: {
                if (null != related.getRelationshipName()) {
                    query.in(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.inE(new String[0]).hasEid(related.getRelationshipId()).inV();
                break;
            }
            case SOURCE: {
                if (null != related.getRelationshipName()) {
                    query.out(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.outE(new String[0]).hasEid(related.getRelationshipId()).outV();
                break;
            }
            case ANY: {
                if (null != related.getRelationshipName()) {
                    query.both(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.bothE(new String[0]).hasEid(related.getRelationshipId()).bothV();
            }
        }
        if (related.getEntity() != null) {
            Constants.Type desiredType = Constants.Type.of(related.getEntity());
            query.hasType(desiredType).hasEid(related.getEntity().getId());
        }
    }
}

