/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Map;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.impl.tinkerpop.AbstractGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;
import org.hawkular.inventory.impl.tinkerpop.RelationshipBrowser;

final class RelationshipService<E extends Entity<B, U>, B extends Entity.Blueprint, U extends AbstractElement.Update>
extends AbstractGraphService
implements Relationships.ReadWrite,
Relationships.Read {
    static final String[] MAPPED_PROPERTIES = new String[]{Constants.Property.__eid.name()};
    private final InventoryContext context;
    private final Relationships.Direction direction;
    private final PathContext pathContext;
    private final Class<E> sourceEntityClass;

    RelationshipService(InventoryContext iContext, PathContext ctx, Class<E> sourceClass, Relationships.Direction direction) {
        super(iContext, ctx.sourcePath);
        this.context = iContext;
        this.pathContext = ctx;
        this.direction = direction;
        this.sourceEntityClass = sourceClass;
    }

    public Relationships.Single get(String id) {
        return this.createSingleBrowser(new RelationFilter[]{RelationWith.id((String)id)});
    }

    public Relationships.Multiple getAll(RelationFilter ... filters) {
        return this.createMultiBrowser(filters);
    }

    private Relationships.Single createSingleBrowser(RelationFilter ... filters) {
        return RelationshipBrowser.single(this.context, this.sourceEntityClass, this.direction, this.pathWith(this.pathContext.candidatesFilters).get(), filters);
    }

    private Relationships.Multiple createMultiBrowser(RelationFilter ... filters) {
        return RelationshipBrowser.multiple(this.context, this.direction, this.pathWith(this.pathContext.candidatesFilters).get(), filters);
    }

    public Relationships.Multiple named(String name) {
        return this.createMultiBrowser(new RelationFilter[]{RelationWith.name((String)name)});
    }

    public Relationships.Multiple named(Relationships.WellKnown name) {
        return this.named(name.name());
    }

    public Relationships.Single linkWith(String name, Entity targetOrSource, Map<String, String> properties) {
        if (null == name) {
            throw new IllegalArgumentException("name was null");
        }
        if (null == targetOrSource) {
            throw new IllegalArgumentException("targetOrSource was null");
        }
        Vertex incidenceVertex = this.convert(targetOrSource);
        if (Relationships.WellKnown.contains.name().equals(name)) {
            Direction d = this.direction == Relationships.Direction.outgoing ? Direction.OUT : (this.direction == Relationships.Direction.incoming ? Direction.IN : Direction.BOTH);
            this.checkContains(d, incidenceVertex);
        }
        GremlinPipeline pipe = null;
        switch (this.direction) {
            case outgoing: {
                pipe = this.source().linkOut(name, incidenceVertex).cap().cast(Edge.class);
                break;
            }
            case incoming: {
                pipe = this.source().linkIn(name, incidenceVertex).cap().cast(Edge.class);
                break;
            }
            case both: {
                pipe = this.source().linkBoth(name, incidenceVertex).cap().cast(Edge.class);
            }
        }
        Edge newEdge = (Edge)pipe.next();
        newEdge.setProperty(Constants.Property.__eid.name(), (Object)newEdge.getId().toString());
        this.context.getGraph().commit();
        return this.createSingleBrowser(new RelationFilter[]{RelationWith.id((String)newEdge.getId().toString())});
    }

    public Relationships.Single linkWith(Relationships.WellKnown name, Entity targetOrSource, Map<String, String> properties) {
        return this.linkWith(name.name(), targetOrSource, null);
    }

    public void update(String id, Relationship.Update update) throws RelationNotFoundException {
        Edge edge = this.context.getGraph().getEdge((Object)id);
        RelationshipService.checkProperties(update.getProperties(), MAPPED_PROPERTIES);
        RelationshipService.updateProperties((Element)edge, update.getProperties(), MAPPED_PROPERTIES);
        this.context.getGraph().commit();
    }

    public void delete(String id) throws RelationNotFoundException {
        if (null == id) {
            throw new IllegalArgumentException("relationship's id was null");
        }
        HawkularPipeline pipe = null;
        switch (this.direction) {
            case outgoing: {
                pipe = this.source().outE(new String[0]).hasEid(id);
                break;
            }
            case incoming: {
                pipe = this.source().inE(new String[0]).hasEid(id);
                break;
            }
            case both: {
                pipe = this.source().bothE(new String[0]).hasEid(id);
            }
        }
        if (!pipe.hasNext()) {
            throw new RelationNotFoundException(id, (Filter[])null);
        }
        pipe.remove();
    }

    private void checkContains(Direction direction, Vertex incidenceVertex) {
        if (direction == Direction.BOTH) {
            throw new IllegalArgumentException("2 vertices cannot contain each other.");
        }
        if (direction == Direction.OUT && incidenceVertex.getEdges(Direction.IN, new String[]{Relationships.WellKnown.contains.name()}).iterator().hasNext()) {
            throw new IllegalArgumentException("The target is already contained in another entity.");
        }
        if (direction == Direction.IN && ((Vertex)this.source().iterator().next()).getEdges(Direction.IN, new String[]{Relationships.WellKnown.contains.name()}).iterator().hasNext()) {
            throw new IllegalArgumentException("The source is already contained in another entity.");
        }
        Vertex thisVertex = (Vertex)this.source().iterator().next();
        if (thisVertex.getId().equals(incidenceVertex.getId())) {
            throw new IllegalArgumentException("An entity cannot contain itself.");
        }
        if (direction == Direction.IN && this.source().as("source").out(new String[]{Relationships.WellKnown.contains.name()}).loop("source", l -> !((Vertex)l.getObject()).getId().equals(incidenceVertex.getId())).count() > 0L) {
            throw new IllegalArgumentException("The target (indirectly) contains the source. The source therefore cannot contain the target.");
        }
        if (direction == Direction.OUT && this.source().as("source").in(new String[]{Relationships.WellKnown.contains.name()}).loop("source", l -> !((Vertex)l.getObject()).getId().equals(incidenceVertex.getId())).count() > 0L) {
            throw new IllegalArgumentException("The source (indirectly) contains the target. The target therefore cannot contain the source.");
        }
    }
}

