/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Arrays;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;
import org.hawkular.inventory.impl.tinkerpop.ResourceBrowser;

final class ResourcesService
extends AbstractSourcedGraphService<Resources.Single, Resources.Multiple, Resource, Resource.Blueprint, Resource.Update>
implements Resources.ReadWrite,
Resources.Read {
    public ResourcesService(InventoryContext context, PathContext ctx) {
        super(context, Resource.class, ctx);
    }

    @Override
    protected Filter[] initNewEntity(Vertex newEntity, Resource.Blueprint blueprint) {
        Vertex envVertex = null;
        HawkularPipeline<?, Vertex> envs = this.source().hasType(Constants.Type.environment);
        if (envs.hasNext()) {
            envVertex = (Vertex)envs.next();
        }
        Vertex feedVertex = null;
        HawkularPipeline<?, Vertex> fs = this.source().hasType(Constants.Type.feed);
        if (fs.hasNext()) {
            feedVertex = (Vertex)fs.next();
        }
        if (feedVertex != null && envVertex != null) {
            throw new IllegalStateException("Found both a feed and an environment as a containing entity when creating a resource under path: " + Arrays.deepToString((Object[])FilterApplicator.filters(this.sourcePaths)));
        }
        if (feedVertex == null && envVertex == null) {
            throw new IllegalArgumentException("No feed or environment found to create the resource under path: " + Arrays.deepToString((Object[])FilterApplicator.filters(this.sourcePaths)));
        }
        this.addEdge(envVertex == null ? feedVertex : envVertex, Relationships.WellKnown.contains.name(), newEntity);
        Vertex tenant = ResourcesService.getTenantVertexOf(envVertex == null ? feedVertex : envVertex);
        GremlinPipeline rts = new HawkularPipeline(tenant).out(Relationships.WellKnown.contains).hasType(Constants.Type.resourceType).hasEid(blueprint.getResourceTypeId()).cast(Vertex.class);
        if (!rts.hasNext()) {
            throw new IllegalArgumentException("Could not find resource type with id: " + blueprint.getResourceTypeId());
        }
        this.addEdge((Vertex)rts.next(), Relationships.WellKnown.defines.name(), newEntity);
        Filter.Accumulator f = Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)ResourcesService.getEid(tenant)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class)});
        if (feedVertex == null) {
            f.and((Filter)With.id((String)ResourcesService.getEid(envVertex)));
        } else {
            Vertex env = ResourcesService.getEnvironmentVertexOf(feedVertex);
            f.and(new Filter[]{With.id((String)ResourcesService.getEid(env)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class), With.id((String)ResourcesService.getEid(feedVertex))});
        }
        return f.and(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Resource.class), With.id((String)ResourcesService.getEid(newEntity))}).get();
    }

    @Override
    protected Resources.Single createSingleBrowser(FilterApplicator.Tree path) {
        return ResourceBrowser.single(this.context, path);
    }

    @Override
    protected Resources.Multiple createMultiBrowser(FilterApplicator.Tree path) {
        return ResourceBrowser.multiple(this.context, path);
    }

    @Override
    protected String getProposedId(Resource.Blueprint b) {
        return b.getId();
    }
}

