/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.impl.tinkerpop.AbstractBrowser;
import org.hawkular.inventory.impl.tinkerpop.EnvironmentsService;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.MetricTypesService;
import org.hawkular.inventory.impl.tinkerpop.ResourceTypesService;

final class TenantBrowser
extends AbstractBrowser<Tenant, Tenant.Blueprint, Tenant.Update> {
    private TenantBrowser(InventoryContext context, FilterApplicator.Tree path) {
        super(context, Tenant.class, path);
    }

    public static Tenants.Single single(InventoryContext context, FilterApplicator.Tree path) {
        final TenantBrowser b = new TenantBrowser(context, path);
        return new Tenants.Single(){

            public ResourceTypes.ReadWrite resourceTypes() {
                return b.types();
            }

            public MetricTypes.ReadWrite metricTypes() {
                return b.metricDefinitions();
            }

            public Environments.ReadWrite environments() {
                return b.environments();
            }

            public Relationships.ReadWrite relationships() {
                return b.relationships();
            }

            public Relationships.ReadWrite relationships(Relationships.Direction direction) {
                return b.relationships(direction);
            }

            public Tenant entity() throws EntityNotFoundException, RelationNotFoundException {
                return (Tenant)b.entity();
            }
        };
    }

    public static Tenants.Multiple multiple(InventoryContext context, FilterApplicator.Tree path) {
        final TenantBrowser b = new TenantBrowser(context, path);
        return new Tenants.Multiple(){

            public ResourceTypes.Read resourceTypes() {
                return b.types();
            }

            public MetricTypes.Read metricTypes() {
                return b.metricDefinitions();
            }

            public Environments.Read environments() {
                return b.environments();
            }

            public Relationships.Read relationships() {
                return b.relationships();
            }

            public Relationships.Read relationships(Relationships.Direction direction) {
                return b.relationships(direction);
            }

            public Page<Tenant> entities(Pager pager) {
                return b.entities(pager);
            }
        };
    }

    public EnvironmentsService environments() {
        return new EnvironmentsService(this.context, this.pathToHereWithSelect(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class)})));
    }

    public ResourceTypesService types() {
        return new ResourceTypesService(this.context, this.pathToHereWithSelect(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class)})));
    }

    public MetricTypesService metricDefinitions() {
        return new MetricTypesService(this.context, this.pathToHereWithSelect(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(MetricType.class)})));
    }
}

