/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.impl.tinkerpop.AbstractBrowser;
import org.hawkular.inventory.impl.tinkerpop.FeedsService;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.MetricsService;
import org.hawkular.inventory.impl.tinkerpop.ResourcesService;

final class EnvironmentBrowser
extends AbstractBrowser<Environment, Environment.Blueprint, Environment.Update> {
    private EnvironmentBrowser(InventoryContext context, FilterApplicator.Tree path) {
        super(context, Environment.class, path);
    }

    public static Environments.Single single(InventoryContext context, FilterApplicator.Tree path) {
        final EnvironmentBrowser b = new EnvironmentBrowser(context, path);
        return new Environments.Single(){

            public Feeds.ReadWrite feeds() {
                return b.feeds();
            }

            public Resources.ReadWrite feedlessResources() {
                return b.resources();
            }

            public Metrics.ReadWrite feedlessMetrics() {
                return b.metrics();
            }

            public Relationships.ReadWrite relationships() {
                return b.relationships();
            }

            public Relationships.ReadWrite relationships(Relationships.Direction direction) {
                return b.relationships(direction);
            }

            public ResolvingToMultiple<Metrics.Multiple> allMetrics() {
                return b.allMetrics();
            }

            public ResolvingToMultiple<Resources.Multiple> allResources() {
                return b.allResources();
            }

            public Environment entity() throws EntityNotFoundException, RelationNotFoundException {
                return (Environment)b.entity();
            }
        };
    }

    public static Environments.Multiple multiple(InventoryContext context, FilterApplicator.Tree path) {
        final EnvironmentBrowser b = new EnvironmentBrowser(context, path);
        return new Environments.Multiple(){

            public Feeds.Read feeds() {
                return b.feeds();
            }

            public Resources.Read feedlessResources() {
                return b.resources();
            }

            public Metrics.Read feedlessMetrics() {
                return b.metrics();
            }

            public Relationships.Read relationships() {
                return b.relationships();
            }

            public Relationships.Read relationships(Relationships.Direction direction) {
                return b.relationships(direction);
            }

            public Page<Environment> entities(Pager pager) {
                return b.entities(pager);
            }

            public ResolvingToMultiple<Metrics.Multiple> allMetrics() {
                return b.allMetrics();
            }

            public ResolvingToMultiple<Resources.Multiple> allResources() {
                return b.allResources();
            }
        };
    }

    public FeedsService feeds() {
        return new FeedsService(this.context, this.pathToHereWithSelect(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class)})));
    }

    public ResourcesService resources() {
        return new ResourcesService(this.context, this.pathToHereWithSelect(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Resource.class)})));
    }

    public MetricsService metrics() {
        return new MetricsService(this.context, this.pathToHereWithSelect(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Metric.class)})));
    }

    public ResourcesService allResources() {
        return new ResourcesService(this.context, this.pathToHereWithSelects(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Resource.class)}), Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Resource.class)})));
    }

    public MetricsService allMetrics() {
        return new MetricsService(this.context, this.pathToHereWithSelects(Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Metric.class)}), Filter.by((Filter[])new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Metric.class)})));
    }
}

