/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FeedBrowser;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;

final class FeedsService
extends AbstractSourcedGraphService<Feeds.Single, Feeds.Multiple, Feed, Feed.Blueprint, Feed.Update>
implements Feeds.ReadWrite,
Feeds.Read {
    FeedsService(InventoryContext context, PathContext ctx) {
        super(context, Feed.class, ctx);
    }

    @Override
    protected Filter[] initNewEntity(Vertex newEntity, Feed.Blueprint blueprint) {
        Vertex env = null;
        Iterator iterator = this.source().hasType(Constants.Type.environment).iterator();
        while (iterator.hasNext()) {
            Vertex sourceEnv = (Vertex)iterator.next();
            this.addEdge(sourceEnv, Relationships.WellKnown.contains.name(), newEntity);
            env = sourceEnv;
        }
        Vertex tenant = FeedsService.getTenantVertexOf(env);
        return Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)FeedsService.getEid(tenant)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)FeedsService.getEid(env)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class), With.id((String)FeedsService.getEid(newEntity))}).get();
    }

    @Override
    protected Feeds.Single createSingleBrowser(FilterApplicator.Tree path) {
        return FeedBrowser.single(this.context, path);
    }

    @Override
    protected Feeds.Multiple createMultiBrowser(FilterApplicator.Tree path) {
        return FeedBrowser.multiple(this.context, path);
    }

    @Override
    protected String getProposedId(Feed.Blueprint b) {
        Vertex env = null;
        Iterator iterator = this.source().hasType(Constants.Type.environment).iterator();
        while (iterator.hasNext()) {
            Vertex sourceEnv;
            env = sourceEnv = (Vertex)iterator.next();
        }
        Vertex tenant = FeedsService.getTenantVertexOf(env);
        String envId = FeedsService.getEid(env);
        String tenantId = FeedsService.getEid(tenant);
        return this.context.getFeedIdStrategy().generate((Inventory)this.context.getInventory(), new Feed(tenantId, envId, b.getId()));
    }
}

