/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.pipes.Pipe;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hawkular.inventory.api.filters.Contained;
import org.hawkular.inventory.api.filters.Defined;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Owned;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.impl.tinkerpop.FilterVisitor;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.PathVisitor;
import org.hawkular.inventory.impl.tinkerpop.RelationshipBrowser;

abstract class FilterApplicator<T extends Filter> {
    protected final Type type;
    protected final T filter;
    private static Map<Class<? extends Filter>, Class<? extends FilterApplicator>> applicators = new HashMap<Class<? extends Filter>, Class<? extends FilterApplicator>>();

    private FilterApplicator(Type type, T f) {
        this.type = type;
        this.filter = f;
    }

    public static <S, E> void applyAll(Tree filterTree, HawkularPipeline<S, E> q) {
        if (filterTree == null) {
            return;
        }
        for (FilterApplicator<S> filterApplicator : filterTree.filters) {
            filterApplicator.applyTo(q);
        }
        if (filterTree.subTrees.isEmpty()) {
            return;
        }
        if (filterTree.subTrees.size() == 1) {
            FilterApplicator.applyAll(filterTree.subTrees.get(0), q);
        } else {
            ArrayList branches = new ArrayList();
            for (Tree t : filterTree.subTrees) {
                HawkularPipeline hawkularPipeline = new HawkularPipeline();
                FilterApplicator.applyAll(t, hawkularPipeline);
                branches.add(hawkularPipeline);
            }
            q.copySplit((Pipe[])branches.toArray(new HawkularPipeline[branches.size()])).exhaustMerge().dedup();
        }
    }

    private static Filter[] filters(FilterApplicator ... applicators) {
        Filter[] ret = new Filter[applicators.length];
        for (int i = 0; i < applicators.length; ++i) {
            ret[i] = applicators[i].filter;
        }
        return ret;
    }

    public static Filter[][] filters(Tree applicators) {
        ArrayList paths = new ArrayList();
        ArrayDeque<Filter[]> path = new ArrayDeque<Filter[]>();
        ArrayDeque<Iterator<Tree>> traversalPosition = new ArrayDeque<Iterator<Tree>>();
        path.add(FilterApplicator.filters(applicators.filters));
        traversalPosition.push(applicators.subTrees.iterator());
        while (!traversalPosition.isEmpty()) {
            Iterator currentPos = (Iterator)traversalPosition.peek();
            if (currentPos.hasNext()) {
                Tree child = (Tree)currentPos.next();
                if (child.subTrees.isEmpty()) {
                    ArrayList pathToLeaf = new ArrayList();
                    for (Filter[] fs : path) {
                        Collections.addAll(pathToLeaf, fs);
                    }
                    Collections.addAll(pathToLeaf, FilterApplicator.filters(child.filters));
                    paths.add(pathToLeaf);
                    continue;
                }
                path.add(FilterApplicator.filters(child.filters));
                traversalPosition.push(child.subTrees.iterator());
                continue;
            }
            traversalPosition.pop();
            path.removeLast();
        }
        Filter[][] ret = new Filter[paths.size()][];
        Arrays.setAll(ret, i -> ((List)paths.get(i)).toArray(new Filter[((List)paths.get(i)).size()]));
        return ret;
    }

    private static FilterApplicator<?>[] with(Type type, Filter ... filters) {
        FilterApplicator[] ret = new FilterApplicator[filters.length];
        Arrays.setAll(ret, i -> FilterApplicator.with(type, filters[i]));
        return ret;
    }

    private static FilterApplicator<?> with(Type type, Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        Class<?> filterClazz = filter.getClass();
        Class<? extends FilterApplicator> applicatorClazz = applicators.get(filterClazz);
        if (applicatorClazz == null) {
            throw new IllegalArgumentException("Unsupported filter type " + filterClazz);
        }
        Constructor<? extends FilterApplicator> constructor = null;
        try {
            constructor = applicatorClazz.getDeclaredConstructor(filterClazz, Type.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = applicatorClazz.getDeclaredConstructor(filterClazz.getSuperclass(), Type.class);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException("Unable to create an instance of " + applicatorClazz);
            }
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[]{filter, type});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create an instance of " + applicatorClazz);
        }
    }

    public static SymmetricTreeExtender from(Type type, Filter[][] filters) {
        return new SymmetricTreeExtender(type, filters);
    }

    public static SymmetricTreeExtender fromPath(Filter[][] filters) {
        return FilterApplicator.from(Type.PATH, filters);
    }

    public static SymmetricTreeExtender fromPath(Filter ... filters) {
        Filter[][] fs = new Filter[][]{filters};
        return FilterApplicator.fromPath(fs);
    }

    public static SymmetricTreeExtender from(Tree filters) {
        return new SymmetricTreeExtender(filters);
    }

    public abstract void applyTo(HawkularPipeline<?, ?> var1);

    public Filter filter() {
        return this.filter;
    }

    public String toString() {
        return "FilterApplicator[type=" + (Object)((Object)this.type) + ", filter=" + this.filter + "]";
    }

    /* synthetic */ FilterApplicator(Type x0, Filter x1, 1 x2) {
        this(x0, x1);
    }

    static {
        applicators.put(Related.class, RelatedApplicator.class);
        applicators.put(Contained.class, RelatedApplicator.class);
        applicators.put(Defined.class, RelatedApplicator.class);
        applicators.put(Owned.class, RelatedApplicator.class);
        applicators.put(With.Ids.class, WithIdsApplicator.class);
        applicators.put(With.Types.class, WithTypesApplicator.class);
        applicators.put(RelationWith.Ids.class, RelationWithIdsApplicator.class);
        applicators.put(RelationWith.Properties.class, RelationWithPropertiesApplicator.class);
        applicators.put(RelationWith.SourceOfType.class, RelationWithSourcesOfTypesApplicator.class);
        applicators.put(RelationWith.TargetOfType.class, RelationWithTargetsOfTypesApplicator.class);
        applicators.put(RelationWith.SourceOrTargetOfType.class, RelationWithSourcesOrTargetsOfTypesApplicator.class);
        applicators.put(RelationshipBrowser.JumpInOutFilter.class, RelationWithJumpInOutApplicator.class);
    }

    public static final class Tree {
        FilterApplicator<?>[] filters;
        List<Tree> subTrees = new ArrayList<Tree>();

        private Tree() {
        }

        public Builder asBuilder() {
            Builder b = new Builder();
            b.filters = new ArrayList(Arrays.asList(this.filters));
            for (Tree subTree : this.subTrees) {
                Builder childBuilder = subTree.asBuilder();
                childBuilder.parent = b;
                b.children.add(childBuilder);
            }
            return b;
        }

        public static final class Builder {
            List<FilterApplicator<?>> filters = new ArrayList();
            Tree tree = new Tree();
            Builder parent;
            List<Builder> children = new ArrayList<Builder>();
            boolean done;

            Builder branch() {
                Builder child = new Builder();
                child.parent = this;
                this.children.add(child);
                return child;
            }

            Builder done() {
                if (this.done) {
                    return this.parent;
                }
                this.tree.filters = this.filters.toArray(new FilterApplicator[this.filters.size()]);
                if (this.parent != null) {
                    this.parent.tree.subTrees.add(this.tree);
                    this.parent.children.remove(this);
                }
                new ArrayList<Builder>(this.children).forEach(Builder::done);
                this.done = true;
                return this.parent;
            }

            Builder with(FilterApplicator<?> ... filters) {
                Collections.addAll(this.filters, filters);
                return this;
            }

            Tree build() {
                Builder root = this;
                while (root.parent != null) {
                    root = root.parent;
                }
                root.done();
                return root.tree;
            }
        }
    }

    static class SymmetricTreeExtender {
        private Tree.Builder filters;

        private SymmetricTreeExtender(Type type, Filter[][] filters) {
            this.filters = new Tree.Builder();
            this.and(type, filters);
        }

        private SymmetricTreeExtender(Tree filters) {
            this.filters = filters.asBuilder();
        }

        public SymmetricTreeExtender and(Type type, Filter[][] filters) {
            this.onLeaves(this.filters, t -> {
                for (Filter[] fs : filters) {
                    t.branch().with(FilterApplicator.with(type, fs));
                }
            });
            return this;
        }

        public SymmetricTreeExtender and(Type type, Filter ... filters) {
            this.onLeaves(this.filters, t -> t.with(FilterApplicator.with(type, filters)));
            return this;
        }

        public SymmetricTreeExtender andFilter(Filter ... filters) {
            return this.and(Type.FILTER, filters);
        }

        public SymmetricTreeExtender andPath(Filter ... path) {
            return this.and(Type.PATH, path);
        }

        public SymmetricTreeExtender andPath(Filter[][] path) {
            return this.and(Type.PATH, path);
        }

        public Tree get() {
            return this.filters.build();
        }

        private void onLeaves(Tree.Builder root, Consumer<Tree.Builder> leafMutator) {
            if (root.children.isEmpty()) {
                leafMutator.accept(root);
            } else {
                for (Tree.Builder c : root.children) {
                    this.onLeaves(c, leafMutator);
                }
            }
        }
    }

    private static final class RelationWithJumpInOutApplicator
    extends FilterApplicator<RelationshipBrowser.JumpInOutFilter> {
        private RelationWithJumpInOutApplicator(RelationshipBrowser.JumpInOutFilter filter, Type type) {
            super(type, filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (RelationshipBrowser.JumpInOutFilter)this.filter);
        }
    }

    private static final class RelationWithSourcesOrTargetsOfTypesApplicator
    extends FilterApplicator<RelationWith.SourceOrTargetOfType> {
        private RelationWithSourcesOrTargetsOfTypesApplicator(RelationWith.SourceOrTargetOfType filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (RelationWith.SourceOrTargetOfType)this.filter);
        }
    }

    private static final class RelationWithTargetsOfTypesApplicator
    extends FilterApplicator<RelationWith.TargetOfType> {
        private RelationWithTargetsOfTypesApplicator(RelationWith.TargetOfType filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (RelationWith.TargetOfType)this.filter);
        }
    }

    private static final class RelationWithSourcesOfTypesApplicator
    extends FilterApplicator<RelationWith.SourceOfType> {
        private RelationWithSourcesOfTypesApplicator(RelationWith.SourceOfType filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (RelationWith.SourceOfType)this.filter);
        }
    }

    private static final class RelationWithPropertiesApplicator
    extends FilterApplicator<RelationWith.Properties> {
        private RelationWithPropertiesApplicator(RelationWith.Properties filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (RelationWith.Properties)this.filter);
        }
    }

    private static final class RelationWithIdsApplicator
    extends FilterApplicator<RelationWith.Ids> {
        private RelationWithIdsApplicator(RelationWith.Ids filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (RelationWith.Ids)this.filter);
        }
    }

    public static enum Type {
        PATH(new PathVisitor()),
        FILTER(new FilterVisitor());

        final FilterVisitor visitor;

        private Type(FilterVisitor visitor) {
            this.visitor = visitor;
        }
    }

    private static final class WithTypesApplicator
    extends FilterApplicator<With.Types> {
        private WithTypesApplicator(With.Types filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (With.Types)this.filter);
        }
    }

    private static final class WithIdsApplicator
    extends FilterApplicator<With.Ids> {
        private WithIdsApplicator(With.Ids filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (With.Ids)this.filter);
        }
    }

    private static final class RelatedApplicator<T extends Related<?>>
    extends FilterApplicator<Related<?>> {
        private RelatedApplicator(T filter, Type type) {
            super(type, (Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.type.visitor.visit(query, (Related<? extends Entity>)((Related)this.filter));
        }
    }
}

