/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.impl.tinkerpop.AbstractGraphService;
import org.hawkular.inventory.impl.tinkerpop.EnvironmentsService;
import org.hawkular.inventory.impl.tinkerpop.FeedsService;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.MetricTypesService;
import org.hawkular.inventory.impl.tinkerpop.MetricsService;
import org.hawkular.inventory.impl.tinkerpop.RelationshipService;
import org.hawkular.inventory.impl.tinkerpop.ResourceTypesService;
import org.hawkular.inventory.impl.tinkerpop.ResourcesService;
import org.hawkular.inventory.impl.tinkerpop.TenantsService;

final class RelationshipBrowser
extends AbstractGraphService {
    private RelationshipBrowser(InventoryContext iContext, FilterApplicator.Tree path) {
        super(iContext, path);
    }

    public static <T extends Entity<B, U>, B extends Entity.Blueprint, U extends AbstractElement.Update> Relationships.Single single(InventoryContext iContext, final Class<T> sourceClass, Relationships.Direction direction, FilterApplicator.Tree path, RelationFilter[] filters) {
        JumpInOutFilter goToEdge = new JumpInOutFilter(direction, false);
        final RelationshipBrowser b = new RelationshipBrowser(iContext, AbstractGraphService.pathWith(path, goToEdge).andFilter((Filter[])filters).get());
        return new Relationships.Single(){

            public Relationship entity() throws EntityNotFoundException, RelationNotFoundException {
                GremlinPipeline edges = b.source().cast(Edge.class);
                if (!edges.hasNext()) {
                    throw new RelationNotFoundException(sourceClass, FilterApplicator.filters(b.sourcePaths));
                }
                Edge edge = (Edge)edges.next();
                Relationship relationship = new Relationship(AbstractGraphService.getEid(edge), edge.getLabel(), AbstractGraphService.convert(edge.getVertex(Direction.OUT)), AbstractGraphService.convert(edge.getVertex(Direction.IN)));
                Map properties = edge.getPropertyKeys().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((Edge)edge).getProperty(arg_0)));
                Arrays.asList(RelationshipService.MAPPED_PROPERTIES).forEach(properties::remove);
                return (Relationship)relationship.update().with((AbstractElement.Update)((Relationship.Update.Builder)Relationship.Update.builder().withProperties(properties)).build());
            }
        };
    }

    public static Relationships.Multiple multiple(InventoryContext iContext, Relationships.Direction direction, FilterApplicator.Tree path, RelationFilter[] filters) {
        JumpInOutFilter goToEdge = new JumpInOutFilter(direction, false);
        final JumpInOutFilter goFromEdge = new JumpInOutFilter(direction, true);
        final RelationshipBrowser b = new RelationshipBrowser(iContext, AbstractGraphService.pathWith(path, goToEdge).andFilter((Filter[])filters).get());
        return new Relationships.Multiple(){

            public Page<Relationship> entities(Pager pager) {
                GremlinPipeline edges = b.source().counter("total").page(pager).cast(Edge.class);
                List<String> mappedProperties = Arrays.asList(RelationshipService.MAPPED_PROPERTIES);
                Stream<Relationship> relationshipStream = StreamSupport.stream(edges.spliterator(), false).map(edge -> {
                    Relationship relationship = new Relationship(AbstractGraphService.getEid(edge), edge.getLabel(), AbstractGraphService.convert(edge.getVertex(Direction.OUT)), AbstractGraphService.convert(edge.getVertex(Direction.IN)));
                    Map properties = edge.getPropertyKeys().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((Edge)edge).getProperty(arg_0)));
                    mappedProperties.forEach(properties::remove);
                    return (Relationship)relationship.update().with((AbstractElement.Update)((Relationship.Update.Builder)Relationship.Update.builder().withProperties(properties)).build());
                });
                return new Page(relationshipStream.collect(Collectors.toList()), (PageContext)pager, edges.getCount("total"));
            }

            public Tenants.Read tenants() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(Tenant.class)});
                return new TenantsService(b.context, b.pathToHereWithSelect(acc));
            }

            public Environments.Read environments() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(Environment.class)});
                return new EnvironmentsService(b.context, b.pathToHereWithSelect(acc));
            }

            public Feeds.Read feeds() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(Feed.class)});
                return new FeedsService(b.context, b.pathToHereWithSelect(acc));
            }

            public MetricTypes.Read metricTypes() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(MetricType.class)});
                return new MetricTypesService(b.context, b.pathToHereWithSelect(acc));
            }

            public Metrics.Read metrics() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(Metric.class)});
                return new MetricsService(b.context, b.pathToHereWithSelect(acc));
            }

            public Resources.Read resources() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(Resource.class)});
                return new ResourcesService(b.context, b.pathToHereWithSelect(acc));
            }

            public ResourceTypes.Read resourceTypes() {
                Filter.Accumulator acc = Filter.by((Filter[])new Filter[]{goFromEdge, With.type(ResourceType.class)});
                return new ResourceTypesService(b.context, b.pathToHereWithSelect(acc));
            }
        };
    }

    static class JumpInOutFilter
    extends Filter {
        private final Relationships.Direction direction;
        private final boolean fromEdge;

        JumpInOutFilter(Relationships.Direction direction, boolean fromEdge) {
            this.direction = direction;
            this.fromEdge = fromEdge;
        }

        public Relationships.Direction getDirection() {
            return this.direction;
        }

        public boolean isFromEdge() {
            return this.fromEdge;
        }

        public String toString() {
            return "Jump[" + (this.fromEdge ? "from " : "to ") + this.direction.name() + " edges]";
        }
    }
}

