/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;
import org.hawkular.inventory.impl.tinkerpop.RelationshipService;

abstract class AbstractBrowser<E extends Entity<B, U>, B extends Entity.Blueprint, U extends AbstractElement.Update>
extends AbstractSourcedGraphService<Void, Void, E, B, U> {
    AbstractBrowser(InventoryContext context, Class<E> entityClass, FilterApplicator.Tree path) {
        super(context, entityClass, new PathContext(path, (Filter[])null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E entity() {
        try {
            this.context.getInventoryLock().readLock().lock();
            HawkularPipeline<?, Vertex> q = this.source();
            if (!q.hasNext()) {
                throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(this.pathContext.sourcePath));
            }
            Entity<?, ?> ret = AbstractBrowser.convert((Vertex)q.next());
            if (!this.isApplicable((AbstractElement<?, ?>)ret)) {
                throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(this.pathContext.sourcePath));
            }
            Entity entity = (Entity)this.entityClass.cast(ret);
            return (E)entity;
        }
        finally {
            this.context.getInventoryLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<E> entities(Pager pager) {
        try {
            this.context.getInventoryLock().readLock().lock();
            HawkularPipeline q = this.context.getResultFilter() == null ? this.source().counter("total").page(pager).transform(v -> (Entity)this.entityClass.cast(AbstractBrowser.convert(v))) : this.source().transform(v -> (Entity)this.entityClass.cast(AbstractBrowser.convert(v))).filter(this::isApplicable).counter("total").page(pager, (e, p) -> {
                if ("id".equals(p)) {
                    return e.getId();
                }
                return (Comparable)e.getProperties().get(p);
            });
            Page page = new Page(q.toList(), (PageContext)pager, q.getCount("total"));
            return page;
        }
        finally {
            this.context.getInventoryLock().readLock().unlock();
        }
    }

    public RelationshipService<E, B, U> relationships() {
        return this.relationships(Relationships.Direction.outgoing);
    }

    public RelationshipService<E, B, U> relationships(Relationships.Direction direction) {
        return new RelationshipService(this.context, new PathContext(this.sourcePaths, (Filter[])null), this.entityClass, direction);
    }

    @Override
    protected final Void createSingleBrowser(FilterApplicator.Tree path) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }

    @Override
    protected final Void createMultiBrowser(FilterApplicator.Tree path) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }

    @Override
    protected final String getProposedId(Entity.Blueprint b) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }

    @Override
    protected final Filter[] initNewEntity(Vertex newEntity, Entity.Blueprint blueprint) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }
}

