/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResultFilter;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;

abstract class AbstractGraphService {
    protected final InventoryContext context;
    protected final FilterApplicator.Tree sourcePaths;

    AbstractGraphService(InventoryContext context, FilterApplicator.Tree sourcePaths) {
        this.context = context;
        this.sourcePaths = sourcePaths;
    }

    protected HawkularPipeline<?, Vertex> source() {
        return this.source(null);
    }

    protected HawkularPipeline<?, Vertex> source(FilterApplicator.Tree filters) {
        GremlinPipeline ret = new HawkularPipeline(this.context.getGraph()).V();
        FilterApplicator.applyAll(this.sourcePaths, ret);
        FilterApplicator.applyAll(filters, ret);
        return ret;
    }

    protected FilterApplicator.SymmetricTreeExtender pathWith(Filter ... filters) {
        Filter[][] fs = new Filter[][]{filters};
        return AbstractGraphService.pathWith(this.sourcePaths, fs);
    }

    protected FilterApplicator.SymmetricTreeExtender pathWith(Filter[][] filters) {
        return AbstractGraphService.pathWith(this.sourcePaths, filters);
    }

    public static FilterApplicator.SymmetricTreeExtender pathWith(FilterApplicator.Tree sourcePaths, Filter[][] filters) {
        return FilterApplicator.from(sourcePaths).and(FilterApplicator.Type.PATH, filters);
    }

    public static FilterApplicator.SymmetricTreeExtender pathWith(FilterApplicator.Tree sourcePaths, Filter ... filters) {
        Filter[][] fs = new Filter[][]{filters};
        return FilterApplicator.from(sourcePaths).and(FilterApplicator.Type.PATH, fs);
    }

    protected boolean isApplicable(AbstractElement<?, ?> result) {
        ResultFilter filter = this.context.getResultFilter();
        return filter == null ? true : filter.isApplicable(result);
    }

    static String getProperty(Vertex v, Constants.Property property) {
        return (String)v.getProperty(property.name());
    }

    static String getEid(Vertex v) {
        return AbstractGraphService.getProperty(v, Constants.Property.__eid);
    }

    static String getEid(Edge e) {
        return (String)e.getProperty(Constants.Property.__eid.name());
    }

    static String getType(Vertex v) {
        return AbstractGraphService.getProperty(v, Constants.Property.__type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Edge addEdge(Vertex source, String label, Vertex target) {
        try {
            this.context.getInventoryLock().writeLock().lock();
            Edge e = source.addEdge(label, target);
            e.setProperty(Constants.Property.__eid.name(), e.getId());
            Edge edge = e;
            return edge;
        }
        finally {
            this.context.getInventoryLock().writeLock().unlock();
        }
    }

    protected Vertex convert(Entity<?, ?> e) {
        GremlinPipeline ret = new HawkularPipeline(this.context.getGraph()).V();
        HawkularPipeline vs = (HawkularPipeline)e.accept(new EntityVisitor<HawkularPipeline<?, ? extends Element>, Void>((HawkularPipeline)ret){
            final /* synthetic */ HawkularPipeline val$ret;
            {
                this.val$ret = hawkularPipeline;
            }

            public HawkularPipeline<?, ? extends Element> visitTenant(Tenant tenant, Void ignored) {
                return this.val$ret.hasType(Constants.Type.tenant);
            }

            public HawkularPipeline<?, ? extends Element> visitEnvironment(Environment environment, Void ignored) {
                return this.val$ret.hasType(Constants.Type.tenant).hasEid(environment.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.environment);
            }

            public HawkularPipeline<?, ? extends Element> visitFeed(Feed feed, Void ignored) {
                return this.val$ret.hasType(Constants.Type.tenant).hasEid(feed.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.environment).hasEid(feed.getEnvironmentId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.feed);
            }

            public HawkularPipeline<?, ? extends Element> visitMetric(Metric metric, Void ignored) {
                if (metric.getFeedId() == null) {
                    return this.val$ret.hasType(Constants.Type.tenant).hasEid(metric.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.environment).hasEid(metric.getEnvironmentId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.metric);
                }
                return this.val$ret.hasType(Constants.Type.tenant).hasEid(metric.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.environment).hasEid(metric.getEnvironmentId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.feed).hasEid(metric.getFeedId()).hasType(Constants.Type.metric);
            }

            public HawkularPipeline<?, ? extends Element> visitMetricType(MetricType type, Void ignored) {
                return this.val$ret.hasType(Constants.Type.tenant).hasEid(type.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.metricType);
            }

            public HawkularPipeline<?, ? extends Element> visitResource(Resource resource, Void ignored) {
                if (resource.getFeedId() == null) {
                    return this.val$ret.hasType(Constants.Type.tenant).hasEid(resource.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.environment).hasEid(resource.getEnvironmentId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.resource);
                }
                return this.val$ret.hasType(Constants.Type.tenant).hasEid(resource.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.environment).hasEid(resource.getEnvironmentId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.feed).hasEid(resource.getFeedId()).hasType(Constants.Type.resource);
            }

            public HawkularPipeline<?, ? extends Element> visitResourceType(ResourceType type, Void ignored) {
                return this.val$ret.hasType(Constants.Type.tenant).hasEid(type.getTenantId()).out(Relationships.WellKnown.contains).hasType(Constants.Type.resourceType);
            }
        }, null);
        return (vs = vs.hasEid(e.getId())).hasNext() ? (Vertex)vs.cast(Vertex.class).next() : null;
    }

    static Entity<?, ?> convert(Vertex v) {
        Tenant e;
        Constants.Type type = Constants.Type.valueOf(AbstractGraphService.getType(v));
        switch (type) {
            case environment: {
                e = new Environment(AbstractGraphService.getEid(AbstractGraphService.getTenantVertexOf(v)), AbstractGraphService.getEid(v));
                break;
            }
            case feed: {
                Vertex environmentVertex = AbstractGraphService.getEnvironmentVertexOf(v);
                e = new Feed(AbstractGraphService.getEid(AbstractGraphService.getTenantVertexOf(environmentVertex)), AbstractGraphService.getEid(environmentVertex), AbstractGraphService.getEid(v));
                break;
            }
            case metric: {
                Vertex environmentVertex = AbstractGraphService.getEnvironmentVertexOrNull(v);
                Vertex feedVertex = AbstractGraphService.getFeedVertexOrNull(v);
                if (environmentVertex == null) {
                    environmentVertex = AbstractGraphService.getEnvironmentVertexOf(feedVertex);
                }
                Vertex mdv = (Vertex)v.getVertices(Direction.IN, new String[]{Relationships.WellKnown.defines.name()}).iterator().next();
                MetricType md = (MetricType)AbstractGraphService.convert(mdv);
                e = new Metric(AbstractGraphService.getEid(AbstractGraphService.getTenantVertexOf(environmentVertex)), AbstractGraphService.getEid(environmentVertex), feedVertex == null ? null : AbstractGraphService.getEid(feedVertex), AbstractGraphService.getEid(v), md);
                break;
            }
            case metricType: {
                e = new MetricType(AbstractGraphService.getEid(AbstractGraphService.getTenantVertexOf(v)), AbstractGraphService.getEid(v), MetricUnit.fromDisplayName((String)AbstractGraphService.getProperty(v, Constants.Property.__unit)));
                break;
            }
            case resource: {
                Vertex environmentVertex = AbstractGraphService.getEnvironmentVertexOrNull(v);
                Vertex feedVertex = AbstractGraphService.getFeedVertexOrNull(v);
                if (environmentVertex == null) {
                    environmentVertex = AbstractGraphService.getEnvironmentVertexOf(feedVertex);
                }
                Vertex rtv = (Vertex)v.getVertices(Direction.IN, new String[]{Relationships.WellKnown.defines.name()}).iterator().next();
                ResourceType rt = (ResourceType)AbstractGraphService.convert(rtv);
                e = new Resource(AbstractGraphService.getEid(AbstractGraphService.getTenantVertexOf(environmentVertex)), AbstractGraphService.getEid(environmentVertex), feedVertex == null ? null : AbstractGraphService.getEid(feedVertex), AbstractGraphService.getEid(v), rt);
                break;
            }
            case resourceType: {
                e = new ResourceType(AbstractGraphService.getEid(AbstractGraphService.getTenantVertexOf(v)), AbstractGraphService.getEid(v), AbstractGraphService.getProperty(v, Constants.Property.__version));
                break;
            }
            case tenant: {
                e = new Tenant(AbstractGraphService.getEid(v));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type of vertex");
            }
        }
        List<String> mappedProps = Arrays.asList(type.getMappedProperties());
        final HashMap filteredProperties = new HashMap();
        v.getPropertyKeys().forEach(k -> {
            if (!mappedProps.contains(k)) {
                filteredProperties.put(k, v.getProperty(k));
            }
        });
        return (Entity)e.accept(new EntityVisitor<Entity<?, ?>, Void>(){

            public Entity<?, ?> visitTenant(Tenant tenant, Void ignored) {
                return (Entity)tenant.update().with((AbstractElement.Update)((Tenant.Update.Builder)Tenant.Update.builder().withProperties(filteredProperties)).build());
            }

            public Entity<?, ?> visitEnvironment(Environment environment, Void ignored) {
                return (Entity)environment.update().with((AbstractElement.Update)((Environment.Update.Builder)Environment.Update.builder().withProperties(filteredProperties)).build());
            }

            public Entity<?, ?> visitFeed(Feed feed, Void ignored) {
                return (Entity)feed.update().with((AbstractElement.Update)((Feed.Update.Builder)Feed.Update.builder().withProperties(filteredProperties)).build());
            }

            public Entity<?, ?> visitMetric(Metric metric, Void ignored) {
                return (Entity)metric.update().with((AbstractElement.Update)((Metric.Update.Builder)Metric.Update.builder().withProperties(filteredProperties)).build());
            }

            public Entity<?, ?> visitMetricType(MetricType metricType, Void ignored) {
                return (Entity)metricType.update().with((AbstractElement.Update)((MetricType.Update.Builder)MetricType.Update.builder().withProperties(filteredProperties)).build());
            }

            public Entity<?, ?> visitResource(Resource resource, Void ignored) {
                return (Entity)resource.update().with((AbstractElement.Update)((Resource.Update.Builder)Resource.Update.builder().withProperties(filteredProperties)).build());
            }

            public Entity<?, ?> visitResourceType(ResourceType type, Void ignored) {
                return (Entity)type.update().with((AbstractElement.Update)((ResourceType.Update.Builder)ResourceType.Update.builder().withProperties(filteredProperties)).build());
            }
        }, null);
    }

    static Vertex getTenantVertexOf(Vertex entityVertex) {
        Constants.Type type = Constants.Type.valueOf(AbstractGraphService.getType(entityVertex));
        switch (type) {
            case environment: 
            case metricType: 
            case resourceType: {
                return (Vertex)entityVertex.getVertices(Direction.IN, new String[]{Relationships.WellKnown.contains.name()}).iterator().next();
            }
            case feed: 
            case metric: 
            case resource: {
                return AbstractGraphService.getTenantVertexOf(AbstractGraphService.getEnvironmentVertexOf(entityVertex));
            }
        }
        return null;
    }

    static Vertex getEnvironmentVertexOf(Vertex entityVertex) {
        Constants.Type type = Constants.Type.valueOf(AbstractGraphService.getType(entityVertex));
        switch (type) {
            case feed: 
            case metric: 
            case resource: {
                return (Vertex)new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.environment).iterator().next();
            }
        }
        return null;
    }

    static Vertex getEnvironmentVertexOrNull(Vertex entityVertex) {
        Constants.Type type = Constants.Type.valueOf(AbstractGraphService.getType(entityVertex));
        switch (type) {
            case feed: 
            case metric: 
            case resource: {
                Iterator envs = new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.environment).iterator();
                if (envs.hasNext()) {
                    return (Vertex)envs.next();
                }
                return null;
            }
        }
        return null;
    }

    static Vertex getFeedVertexOrNull(Vertex entityVertex) {
        Constants.Type type = Constants.Type.valueOf(AbstractGraphService.getType(entityVertex));
        switch (type) {
            case metric: 
            case resource: {
                Iterator feeds = new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.feed).iterator();
                if (feeds.hasNext()) {
                    return (Vertex)feeds.next();
                }
                return null;
            }
        }
        return null;
    }

    protected PathContext pathToHereWithSelect(Filter.Accumulator select) {
        Filter[][] selects = null;
        if (select != null) {
            selects = new Filter[][]{select.get()};
        }
        return new PathContext(this.pathWith(new Filter[0]).get(), selects);
    }

    protected PathContext pathToHereWithSelects(Filter.Accumulator ... selects) {
        Filter[][] sa = new Filter[selects.length][];
        for (int i = 0; i < selects.length; ++i) {
            sa[i] = selects[i].get();
        }
        return new PathContext(this.pathWith(new Filter[0]).get(), sa);
    }

    protected static void updateProperties(Element e, Map<String, Object> properties, String[] disallowedProperties) {
        String[] toRemove;
        HashSet<String> disallowed = new HashSet<String>(Arrays.asList(disallowedProperties));
        for (String p2 : toRemove = (String[])e.getPropertyKeys().stream().filter(p -> !disallowed.contains(p) && !properties.containsKey(p)).toArray(String[]::new)) {
            e.removeProperty(p2);
        }
        properties.forEach((p, v) -> {
            if (!disallowed.contains(p)) {
                e.setProperty(p, v);
            }
        });
    }

    protected static void checkProperties(Map<String, Object> properties, String[] disallowedProperties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashSet<String> disallowed = new HashSet<String>(properties.keySet());
        disallowed.retainAll(Arrays.asList(disallowedProperties));
        if (!disallowed.isEmpty()) {
            throw new IllegalArgumentException("The following properties are reserved for this type of entity: " + Arrays.asList(disallowedProperties));
        }
    }
}

