/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.impl.tinkerpop.AbstractGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;

abstract class AbstractSourcedGraphService<Single, Multiple, E extends Entity<Blueprint, Update>, Blueprint extends Entity.Blueprint, Update extends AbstractElement.Update>
extends AbstractGraphService {
    protected final Class<E> entityClass;
    protected final PathContext pathContext;

    AbstractSourcedGraphService(InventoryContext context, Class<E> entityClass, PathContext pathContext) {
        super(context, pathContext.sourcePath);
        this.entityClass = entityClass;
        this.pathContext = pathContext;
    }

    protected final Filter[][] selectCandidates() {
        return this.pathContext.candidatesFilters;
    }

    public Multiple getAll(Filter ... filters) {
        return this.createMultiBrowser(this.pathWith(this.selectCandidates()).andFilter(filters).get());
    }

    public Single get(String id) {
        return this.createSingleBrowser(this.pathWith(this.selectCandidates()).andPath(new Filter[]{With.ids((String[])new String[]{id})}).get());
    }

    public Single create(Blueprint blueprint) {
        try {
            Single Single2;
            this.context.getInventoryLock().writeLock().lock();
            String id = this.getProposedId(blueprint);
            FilterApplicator.Tree checkPath = FilterApplicator.fromPath(this.selectCandidates()).andFilter(new Filter[]{With.ids((String[])new String[]{id})}).get();
            HawkularPipeline<?, Vertex> check = this.source(checkPath);
            if (check.iterator().hasNext()) {
                throw new EntityAlreadyExistsException(id, FilterApplicator.filters(checkPath));
            }
            this.checkProperties(blueprint.getProperties());
            Vertex v = this.context.getGraph().addVertex(null);
            v.setProperty(Constants.Property.__type.name(), (Object)Constants.Type.of(this.entityClass).name());
            v.setProperty(Constants.Property.__eid.name(), (Object)id);
            if (blueprint.getProperties() != null) {
                for (Map.Entry e : blueprint.getProperties().entrySet()) {
                    v.setProperty((String)e.getKey(), e.getValue());
                }
            }
            try {
                Filter[] path = this.initNewEntity(v, blueprint);
                this.context.getGraph().commit();
                Single2 = this.createSingleBrowser(FilterApplicator.fromPath(path).get());
            }
            catch (Throwable e) {
                this.context.getGraph().rollback();
                throw e;
            }
            return Single2;
        }
        finally {
            this.context.getInventoryLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String id, Update update) {
        this.checkProperties(update.getProperties());
        try {
            this.context.getInventoryLock().writeLock().lock();
            HawkularPipeline<?, Vertex> it = this.source(FilterApplicator.fromPath(this.selectCandidates()).andPath(new Filter[]{With.id((String)id)}).get());
            if (!it.hasNext()) {
                throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(this.pathContext.sourcePath));
            }
            Vertex vertex = (Vertex)it.next();
            AbstractSourcedGraphService.updateProperties((Element)vertex, update.getProperties(), Constants.Type.of(this.entityClass).getMappedProperties());
            this.updateExplicitProperties(update, vertex);
            this.context.getGraph().commit();
        }
        finally {
            this.context.getInventoryLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) {
        try {
            this.context.getInventoryLock().writeLock().lock();
            HawkularPipeline<?, Vertex> vs = this.source(FilterApplicator.fromPath(this.selectCandidates()).andPath(new Filter[]{With.id((String)id)}).get());
            if (!vs.hasNext()) {
                FilterApplicator.Tree fullPath = FilterApplicator.from(this.pathContext.sourcePath).andPath(this.selectCandidates()).andPath(new Filter[]{With.id((String)id)}).get();
                throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(fullPath));
            }
            Vertex v = (Vertex)vs.next();
            HashSet<Vertex> verticesToBeDeletedThatDefineSomething = new HashSet<Vertex>();
            try {
                new HawkularPipeline(v).as("start").out(Relationships.WellKnown.contains).loop("start", x -> true, x -> true).toList().forEach(c -> {
                    if (c.getEdges(Direction.OUT, new String[]{Relationships.WellKnown.defines.name()}).iterator().hasNext()) {
                        verticesToBeDeletedThatDefineSomething.add((Vertex)c);
                    } else {
                        c.remove();
                    }
                });
                if (v.getEdges(Direction.OUT, new String[]{Relationships.WellKnown.defines.name()}).iterator().hasNext()) {
                    verticesToBeDeletedThatDefineSomething.add(v);
                } else {
                    v.remove();
                }
                for (Vertex d : verticesToBeDeletedThatDefineSomething) {
                    if (d.getEdges(Direction.OUT, new String[]{Relationships.WellKnown.defines.name()}).iterator().hasNext()) {
                        this.context.getGraph().rollback();
                        String rootEntity = "Entity[id=" + AbstractSourcedGraphService.getEid(v) + ", type=" + AbstractSourcedGraphService.getType(v) + "]";
                        String definingEntity = "Entity[id=" + AbstractSourcedGraphService.getEid(d) + ", type=" + AbstractSourcedGraphService.getType(d) + "]";
                        throw new IllegalArgumentException("Could not delete entity " + rootEntity + ". The entity " + definingEntity + ", which it (indirectly) contains, acts as a definition for some" + "entities that are not deleted along with it, which would leave them without a " + "definition. This is illegal.");
                    }
                    d.remove();
                }
                this.context.getGraph().commit();
            }
            catch (Exception e) {
                this.context.getGraph().rollback();
                throw e;
            }
        }
        finally {
            this.context.getInventoryLock().writeLock().unlock();
        }
    }

    protected void updateExplicitProperties(Update update, Vertex vertex) {
    }

    protected Relationship addAssociation(Constants.Type typeInSource, Relationships.WellKnown rel, Iterable<Vertex> others) {
        try {
            this.context.getInventoryLock().writeLock().lock();
            Iterator iterator = this.source().hasType(typeInSource).iterator();
            if (iterator.hasNext()) {
                Vertex v = (Vertex)iterator.next();
                Iterator<Vertex> iterator2 = others.iterator();
                if (iterator2.hasNext()) {
                    Vertex o = iterator2.next();
                    for (Edge e : v.getEdges(Direction.OUT, new String[]{rel.name()})) {
                        if (!e.getVertex(Direction.IN).equals(o)) continue;
                        throw new RelationAlreadyExistsException(rel.name(), FilterApplicator.filters(this.sourcePaths));
                    }
                    Edge e = this.addEdge(v, rel.name(), o);
                    Relationship relationship = new Relationship(AbstractSourcedGraphService.getEid(e), e.getLabel(), AbstractSourcedGraphService.convert(e.getVertex(Direction.OUT)), AbstractSourcedGraphService.convert(e.getVertex(Direction.IN)));
                    return relationship;
                }
                throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(FilterApplicator.from(this.sourcePaths).andPath(new Filter[]{Related.by((Relationships.WellKnown)rel)}).get()));
            }
            throw new EntityNotFoundException(typeInSource.getEntityType(), FilterApplicator.filters(this.sourcePaths));
        }
        finally {
            this.context.getInventoryLock().writeLock().unlock();
        }
    }

    protected Relationship findAssociation(String targetId, String label) {
        try {
            this.context.getInventoryLock().readLock().lock();
            Vertex source = (Vertex)this.source().next();
            for (Edge e : source.getEdges(Direction.OUT, new String[]{label})) {
                Vertex target = e.getVertex(Direction.IN);
                if (!AbstractSourcedGraphService.getEid(target).equals(targetId)) continue;
                Relationship relationship = new Relationship(AbstractSourcedGraphService.getEid(e), label, AbstractSourcedGraphService.convert(source), AbstractSourcedGraphService.convert(target));
                return relationship;
            }
            throw new RelationNotFoundException(label, FilterApplicator.filters(this.sourcePaths));
        }
        finally {
            this.context.getInventoryLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Relationship removeAssociation(Constants.Type typeInSource, Relationships.WellKnown rel, String targetUid) {
        try {
            this.context.getInventoryLock().writeLock().lock();
            Constants.Type myType = Constants.Type.of(this.entityClass);
            GremlinPipeline edges = this.source().hasType(typeInSource).outE(new String[]{rel.name()}).and(new Pipe[]{new HawkularPipeline().inV().hasType(myType).hasEid(targetUid)});
            Iterator it = edges.iterator();
            if (!it.hasNext()) {
                throw new RelationNotFoundException(typeInSource.getEntityType(), rel.name(), FilterApplicator.filters(this.sourcePaths), "Relationship does not exist.", null);
            }
            Edge edge = (Edge)it.next();
            Relationship ret = new Relationship(AbstractSourcedGraphService.getEid(edge), edge.getLabel(), AbstractSourcedGraphService.convert(edge.getVertex(Direction.OUT)), AbstractSourcedGraphService.convert(edge.getVertex(Direction.IN)));
            this.context.getGraph().removeEdge(edge);
            Relationship relationship = ret;
            return relationship;
        }
        finally {
            this.context.getInventoryLock().writeLock().unlock();
        }
    }

    protected abstract Single createSingleBrowser(FilterApplicator.Tree var1);

    protected abstract Multiple createMultiBrowser(FilterApplicator.Tree var1);

    protected abstract String getProposedId(Blueprint var1);

    protected abstract Filter[] initNewEntity(Vertex var1, Blueprint var2);

    private void checkProperties(Map<String, Object> properties) {
        Constants.Type type = Constants.Type.of(this.entityClass);
        AbstractSourcedGraphService.checkProperties(properties, type.getMappedProperties());
    }
}

