/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.PropertyFilterPipe;
import java.util.Arrays;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.base.spi.NoopFilter;
import org.hawkular.inventory.base.spi.SwitchElementType;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;

class FilterVisitor {
    FilterVisitor() {
    }

    public void visit(HawkularPipeline<?, ?> query, Related<? extends Entity> related) {
        switch (related.getEntityRole()) {
            case TARGET: {
                if (null != related.getRelationshipName()) {
                    query.in(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.inE(new String[0]).hasEid(related.getRelationshipId()).inV();
                break;
            }
            case SOURCE: {
                if (null != related.getRelationshipName()) {
                    query.out(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.outE(new String[0]).hasEid(related.getRelationshipId()).outV();
                break;
            }
            case ANY: {
                if (null != related.getRelationshipName()) {
                    query.both(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.bothE(new String[0]).hasEid(related.getRelationshipId()).bothV();
            }
        }
        if (related.getEntity() != null) {
            Constants.Type desiredType = Constants.Type.of(related.getEntity());
            query.hasType(desiredType).hasEid(related.getEntity().getId());
        }
    }

    public void visit(HawkularPipeline<?, ?> query, With.Ids ids) {
        if (ids.getIds().length == 1) {
            query.has(Constants.Property.__eid.name(), ids.getIds()[0]);
            return;
        }
        Pipe[] idChecks = new Pipe[ids.getIds().length];
        Arrays.setAll(idChecks, i -> new PropertyFilterPipe(Constants.Property.__eid.name(), (Predicate)Compare.EQUAL, (Object)ids.getIds()[i]));
        query.or(idChecks);
    }

    public void visit(HawkularPipeline<?, ?> query, With.Types types) {
        if (types.getTypes().length == 1) {
            Constants.Type type = Constants.Type.of(types.getTypes()[0]);
            query.has(Constants.Property.__type.name(), type.name());
            return;
        }
        Pipe[] typeChecks = new Pipe[types.getTypes().length];
        Arrays.setAll(typeChecks, i -> {
            Constants.Type type = Constants.Type.of(types.getTypes()[i]);
            return new PropertyFilterPipe(Constants.Property.__type.name(), (Predicate)Compare.EQUAL, (Object)type.name());
        });
        query.or(typeChecks);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.Ids ids) {
        if (ids.getIds().length == 1) {
            query.hasEid(ids.getIds()[0]);
            return;
        }
        Pipe[] idChecks = new Pipe[ids.getIds().length];
        Arrays.setAll(idChecks, i -> new PropertyFilterPipe(Constants.Property.__eid.name(), (Predicate)Compare.EQUAL, (Object)ids.getIds()[i]));
        query.or(idChecks);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.PropertyValues properties) {
        this.applyPropertyFilter(query, properties.getProperty(), properties.getValues());
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.SourceOfType types) {
        this.visit(query, (RelationWith.SourceOrTargetOfType)types, true);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.TargetOfType types) {
        this.visit(query, (RelationWith.SourceOrTargetOfType)types, false);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.SourceOrTargetOfType types) {
        this.visit(query, types, null);
    }

    private void visit(HawkularPipeline<?, ?> query, RelationWith.SourceOrTargetOfType types, Boolean source) {
        HawkularPipeline<?, ?> q1 = query.remember();
        GremlinPipeline q2 = source == null ? q1.bothV() : (source != false ? q1.outV() : q1.inV());
        if (types.getTypes().length == 1) {
            Constants.Type type = Constants.Type.of(types.getTypes()[0]);
            q2.has(Constants.Property.__type.name(), type.name()).recall();
            return;
        }
        Pipe[] typeChecks = new Pipe[types.getTypes().length];
        Arrays.setAll(typeChecks, i -> {
            Constants.Type type = Constants.Type.of(types.getTypes()[i]);
            return new PropertyFilterPipe(Constants.Property.__type.name(), (Predicate)Compare.EQUAL, (Object)type.name());
        });
        q2.or(typeChecks).recall();
    }

    public void visit(HawkularPipeline<?, ?> query, SwitchElementType filter) {
        boolean jumpFromEdge = filter.isFromEdge();
        switch (filter.getDirection()) {
            case incoming: {
                if (jumpFromEdge) {
                    query.outV();
                    break;
                }
                query.inE(new String[0]);
                break;
            }
            case outgoing: {
                if (jumpFromEdge) {
                    query.inV();
                    break;
                }
                query.outE(new String[0]);
                break;
            }
            case both: {
                if (jumpFromEdge) {
                    query.bothV();
                    break;
                }
                query.bothE(new String[0]);
            }
        }
    }

    public void visit(HawkularPipeline<?, ?> query, NoopFilter filter) {
    }

    public void visit(HawkularPipeline<?, ?> query, With.PropertyValues filter) {
        this.applyPropertyFilter(query, filter.getName(), filter.getValues());
    }

    private void applyPropertyFilter(HawkularPipeline<?, ?> query, String propertyName, Object ... values) {
        if (values.length == 0) {
            query.has(propertyName);
        } else if (values.length == 1) {
            query.has(propertyName, values[0]);
        } else {
            Pipe[] checks = new Pipe[values.length];
            Arrays.setAll(checks, i -> new PropertyFilterPipe(propertyName, (Predicate)Compare.EQUAL, values[i]));
            query.or(checks);
        }
    }
}

