/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.spi.CanonicalPath;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;

final class TinkerpopBackend
implements InventoryBackend<Element> {
    private final InventoryContext<?> context;

    public TinkerpopBackend(InventoryContext<?> context) {
        this.context = context;
    }

    public InventoryBackend.Transaction startTransaction(boolean mutating) {
        return this.context.startTransaction(mutating);
    }

    public Element find(CanonicalPath element) throws ElementNotFoundException {
        HawkularPipeline<?, Element> it = this.navigate(element);
        if (!it.hasNext()) {
            throw new ElementNotFoundException();
        }
        return (Element)it.next();
    }

    public Page<Element> query(Query query, Pager pager) {
        GremlinPipeline q = query.getFragments()[0].getFilter() instanceof RelationFilter ? new HawkularPipeline(this.context.getGraph()).E() : new HawkularPipeline(this.context.getGraph()).V();
        FilterApplicator.applyAll(query, q);
        q.counter("total").page(pager);
        return new Page(q.cast(Element.class).toList(), (PageContext)pager, q.getCount("total"));
    }

    public <T extends AbstractElement<?, ?>> Page<T> query(Query query, Pager pager, Function<Element, T> conversion, Function<T, Boolean> filter) {
        GremlinPipeline q = query.getFragments()[0].getFilter() instanceof RelationFilter ? new HawkularPipeline(this.context.getGraph()).E() : new HawkularPipeline(this.context.getGraph()).V();
        FilterApplicator.applyAll(query, q);
        HawkularPipeline q2 = filter == null ? q.counter("total").page(pager).transform(conversion::apply) : q.transform(conversion::apply).filter(filter::apply).counter("total").page(pager, (e, p) -> {
            if ("id".equals(p)) {
                return e.getId();
            }
            return (Comparable)e.getProperties().get(p);
        });
        return new Page(q2.toList(), (PageContext)pager, q.getCount("total"));
    }

    public Iterator<Element> getTransitiveClosureOver(Element startingPoint, String relationshipName, Relationships.Direction direction) {
        if (!(startingPoint instanceof Vertex)) {
            return Collections.emptyList().iterator();
        }
        GremlinPipeline ret = new HawkularPipeline(startingPoint).as("start");
        switch (direction) {
            case incoming: {
                ret.in(new String[]{relationshipName});
                break;
            }
            case outgoing: {
                ret.out(new String[]{relationshipName});
                break;
            }
            case both: {
                ret.both(new String[]{relationshipName});
            }
        }
        return ret.loop("start", x -> true, x -> true).toList().iterator();
    }

    public boolean hasRelationship(Element entity, Relationships.Direction direction, String relationshipName) {
        if (!(entity instanceof Vertex)) {
            return false;
        }
        return ((Vertex)entity).getEdges(TinkerpopBackend.toNative(direction), new String[]{relationshipName}).iterator().hasNext();
    }

    public boolean hasRelationship(Element source, Element target, String relationshipName) {
        if (!(source instanceof Vertex) || !(target instanceof Vertex)) {
            return false;
        }
        Iterator targets = ((Vertex)source).getVertices(Direction.OUT, new String[]{relationshipName}).iterator();
        while (targets.hasNext()) {
            if (!target.equals(targets.next())) continue;
            return true;
        }
        return false;
    }

    public Element getRelationship(Element source, Element target, String relationshipName) throws ElementNotFoundException {
        if (!(source instanceof Vertex) || !(target instanceof Vertex)) {
            throw new IllegalArgumentException("Source or target entity not a vertex.");
        }
        if (relationshipName == null) {
            throw new IllegalArgumentException("relationshipName == null");
        }
        Vertex t = (Vertex)target;
        GremlinPipeline it = new HawkularPipeline(source).outE(new String[]{relationshipName}).remember().inV().hasType(TinkerpopBackend.getType(t)).hasEid(TinkerpopBackend.getEid((Element)t)).recall().cast(Edge.class);
        if (!it.hasNext()) {
            throw new ElementNotFoundException();
        }
        return (Element)it.next();
    }

    public Set<Element> getRelationships(Element entity, Relationships.Direction direction, String ... names) {
        if (!(entity instanceof Vertex)) {
            return Collections.emptySet();
        }
        Vertex v = (Vertex)entity;
        HawkularPipeline q = new HawkularPipeline(v);
        switch (direction) {
            case incoming: {
                q.inE(names);
                break;
            }
            case outgoing: {
                q.outE(names);
                break;
            }
            case both: {
                q.bothE(names);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid relationship direction specified: " + direction));
            }
        }
        return StreamSupport.stream(q.spliterator(), false).collect(Collectors.toSet());
    }

    public String extractId(Element entityRepresentation) {
        return (String)entityRepresentation.getProperty(Constants.Property.__eid.name());
    }

    public Class<? extends AbstractElement<?, ?>> extractType(Element entityRepresentation) {
        if (entityRepresentation instanceof Edge) {
            return Relationship.class;
        }
        return TinkerpopBackend.getType((Vertex)entityRepresentation).getEntityType();
    }

    public <T extends AbstractElement<?, ?>> T convert(Element entityRepresentation, final Class<T> entityType) {
        Tenant e;
        Constants.Type type = Constants.Type.of(this.extractType(entityRepresentation));
        if (type == Constants.Type.relationship) {
            Edge edge = (Edge)entityRepresentation;
            Entity source = this.convert((Element)edge.getVertex(Direction.OUT), Entity.class);
            Entity target = this.convert((Element)edge.getVertex(Direction.IN), Entity.class);
            e = new Relationship(this.extractId((Element)edge), edge.getLabel(), source, target);
        } else {
            Vertex v = (Vertex)entityRepresentation;
            switch (type) {
                case environment: {
                    e = new Environment(this.extractId((Element)TinkerpopBackend.getTenantVertexOf(v)), this.extractId((Element)v));
                    break;
                }
                case feed: {
                    Vertex environmentVertex = TinkerpopBackend.getEnvironmentVertexOf(v);
                    e = new Feed(this.extractId((Element)TinkerpopBackend.getTenantVertexOf(environmentVertex)), this.extractId((Element)environmentVertex), this.extractId((Element)v));
                    break;
                }
                case metric: {
                    Vertex environmentVertex = TinkerpopBackend.getEnvironmentVertexOrNull(v);
                    Vertex feedVertex = TinkerpopBackend.getFeedVertexOrNull(v);
                    if (environmentVertex == null) {
                        environmentVertex = TinkerpopBackend.getEnvironmentVertexOf(feedVertex);
                    }
                    Vertex mdv = (Vertex)v.getVertices(Direction.IN, new String[]{Relationships.WellKnown.defines.name()}).iterator().next();
                    MetricType md = this.convert((Element)mdv, MetricType.class);
                    e = new Metric(this.extractId((Element)TinkerpopBackend.getTenantVertexOf(environmentVertex)), this.extractId((Element)environmentVertex), feedVertex == null ? null : this.extractId((Element)feedVertex), this.extractId((Element)v), md);
                    break;
                }
                case metricType: {
                    e = new MetricType(this.extractId((Element)TinkerpopBackend.getTenantVertexOf(v)), this.extractId((Element)v), MetricUnit.fromDisplayName((String)((String)v.getProperty(Constants.Property.__unit.name()))));
                    break;
                }
                case resource: {
                    Vertex environmentVertex = TinkerpopBackend.getEnvironmentVertexOrNull(v);
                    Vertex feedVertex = TinkerpopBackend.getFeedVertexOrNull(v);
                    if (environmentVertex == null) {
                        environmentVertex = TinkerpopBackend.getEnvironmentVertexOf(feedVertex);
                    }
                    Vertex rtv = (Vertex)v.getVertices(Direction.IN, new String[]{Relationships.WellKnown.defines.name()}).iterator().next();
                    ResourceType rt = this.convert((Element)rtv, ResourceType.class);
                    e = new Resource(this.extractId((Element)TinkerpopBackend.getTenantVertexOf(environmentVertex)), this.extractId((Element)environmentVertex), feedVertex == null ? null : this.extractId((Element)feedVertex), this.extractId((Element)v), rt);
                    break;
                }
                case resourceType: {
                    e = new ResourceType(this.extractId((Element)TinkerpopBackend.getTenantVertexOf(v)), this.extractId((Element)v), (String)v.getProperty(Constants.Property.__version.name()));
                    break;
                }
                case tenant: {
                    e = new Tenant(this.extractId((Element)v));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type of vertex");
                }
            }
        }
        List<String> mappedProps = Arrays.asList(type.getMappedProperties());
        final HashMap filteredProperties = new HashMap();
        entityRepresentation.getPropertyKeys().forEach(k -> {
            if (!mappedProps.contains(k)) {
                filteredProperties.put(k, entityRepresentation.getProperty(k));
            }
        });
        return (T)((AbstractElement)e.accept((ElementVisitor)new ElementVisitor.Simple<T, Void>(){

            public T visitTenant(Tenant tenant, Void ignored) {
                return this.common((AbstractElement)tenant, (AbstractElement.Update.Builder)Tenant.Update.builder());
            }

            public T visitEnvironment(Environment environment, Void ignored) {
                return this.common((AbstractElement)environment, (AbstractElement.Update.Builder)Environment.Update.builder());
            }

            public T visitFeed(Feed feed, Void ignored) {
                return this.common((AbstractElement)feed, (AbstractElement.Update.Builder)Feed.Update.builder());
            }

            public T visitMetric(Metric metric, Void ignored) {
                return this.common((AbstractElement)metric, (AbstractElement.Update.Builder)Metric.Update.builder());
            }

            public T visitMetricType(MetricType metricType, Void ignored) {
                return this.common((AbstractElement)metricType, (AbstractElement.Update.Builder)MetricType.Update.builder());
            }

            public T visitResource(Resource resource, Void ignored) {
                return this.common((AbstractElement)resource, (AbstractElement.Update.Builder)Resource.Update.builder());
            }

            public T visitResourceType(ResourceType type, Void ignored) {
                return this.common((AbstractElement)type, (AbstractElement.Update.Builder)ResourceType.Update.builder());
            }

            public T visitRelationship(Relationship relationship, Void parameter) {
                return this.common((AbstractElement)relationship, (AbstractElement.Update.Builder)Relationship.Update.builder());
            }

            private <U extends AbstractElement.Update> T common(AbstractElement<?, U> entity, AbstractElement.Update.Builder<U, ?> bld) {
                return (AbstractElement)entityType.cast(entity.update().with(bld.withProperties(filteredProperties).build()));
            }
        }, null));
    }

    public Element relate(Element sourceEntity, Element targetEntity, String name, Map<String, Object> properties) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (!(sourceEntity instanceof Vertex)) {
            throw new IllegalArgumentException("Source not a vertex.");
        }
        if (!(targetEntity instanceof Vertex)) {
            throw new IllegalArgumentException("Target not a vertex.");
        }
        Edge e = ((Vertex)sourceEntity).addEdge(name, (Vertex)targetEntity);
        if (properties != null) {
            ElementHelper.setProperties((Element)e, properties);
        }
        e.setProperty(Constants.Property.__eid.name(), (Object)e.getId().toString());
        return e;
    }

    public Element persist(final String id, final AbstractElement.Blueprint blueprint) {
        return (Element)blueprint.accept((ElementBlueprintVisitor)new ElementBlueprintVisitor.Simple<Element, Void>(){

            public Element visitTenant(Tenant.Blueprint tenant, Void parameter) {
                return this.common(blueprint.getProperties(), Tenant.class);
            }

            public Element visitEnvironment(Environment.Blueprint environment, Void parameter) {
                return this.common(blueprint.getProperties(), Environment.class);
            }

            public Element visitFeed(Feed.Blueprint feed, Void parameter) {
                return this.common(blueprint.getProperties(), Feed.class);
            }

            public Element visitMetric(Metric.Blueprint metric, Void parameter) {
                return this.common(blueprint.getProperties(), Metric.class);
            }

            public Element visitMetricType(MetricType.Blueprint definition, Void parameter) {
                return this.common(blueprint.getProperties(), MetricType.class);
            }

            public Element visitResource(Resource.Blueprint resource, Void parameter) {
                return this.common(blueprint.getProperties(), Resource.class);
            }

            public Element visitResourceType(ResourceType.Blueprint type, Void parameter) {
                return this.common(blueprint.getProperties(), ResourceType.class);
            }

            public Element visitRelationship(Relationship.Blueprint relationship, Void parameter) {
                throw new IllegalArgumentException("Relationships cannot be persisted using the persist() method.");
            }

            private Element common(Map<String, Object> properties, Class<? extends AbstractElement<?, ?>> cls) {
                TinkerpopBackend.checkProperties(properties, Constants.Type.of(cls).getMappedProperties());
                Vertex v = TinkerpopBackend.this.context.getGraph().addVertex(null);
                v.setProperty(Constants.Property.__type.name(), (Object)Constants.Type.of(cls).name());
                v.setProperty(Constants.Property.__eid.name(), (Object)id);
                if (properties != null) {
                    ElementHelper.setProperties((Element)v, properties);
                }
                return v;
            }
        }, null);
    }

    public void update(final Element entity, AbstractElement.Update update) {
        update.accept((ElementUpdateVisitor)new ElementUpdateVisitor.Simple<Void, Void>(){

            public Void visitTenant(Tenant.Update tenant, Void parameter) {
                this.common(tenant.getProperties(), Tenant.class);
                return null;
            }

            public Void visitEnvironment(Environment.Update environment, Void parameter) {
                this.common(environment.getProperties(), Environment.class);
                return null;
            }

            public Void visitFeed(Feed.Update feed, Void parameter) {
                this.common(feed.getProperties(), Feed.class);
                return null;
            }

            public Void visitMetric(Metric.Update metric, Void parameter) {
                this.common(metric.getProperties(), Metric.class);
                return null;
            }

            public Void visitMetricType(MetricType.Update definition, Void parameter) {
                this.common(definition.getProperties(), MetricType.class);
                entity.setProperty(Constants.Property.__unit.name(), (Object)definition.getUnit().getDisplayName());
                return null;
            }

            public Void visitResource(Resource.Update resource, Void parameter) {
                this.common(resource.getProperties(), Resource.class);
                return null;
            }

            public Void visitResourceType(ResourceType.Update type, Void parameter) {
                this.common(type.getProperties(), ResourceType.class);
                entity.setProperty(Constants.Property.__version.name(), (Object)type.getVersion());
                return null;
            }

            public Void visitRelationship(Relationship.Update relationship, Void parameter) {
                this.common(relationship.getProperties(), Relationship.class);
                return null;
            }

            private void common(Map<String, Object> properties, Class<? extends AbstractElement<?, ?>> entityType) {
                Class<AbstractElement<?, ?>> actualType = TinkerpopBackend.this.extractType(entity);
                if (!actualType.equals(entityType)) {
                    throw new IllegalArgumentException("Update object doesn't correspond to the actual type of the entity.");
                }
                String[] disallowedProperties = Constants.Type.of(entityType).getMappedProperties();
                TinkerpopBackend.checkProperties(properties, disallowedProperties);
                TinkerpopBackend.updateProperties(entity, properties, disallowedProperties);
            }
        }, null);
    }

    public void delete(Element entity) {
        entity.remove();
    }

    public void commit(InventoryBackend.Transaction t) {
        this.context.commit(t);
    }

    public void rollback(InventoryBackend.Transaction t) {
        this.context.rollback(t);
    }

    public void close() throws Exception {
        this.context.getGraph().shutdown();
    }

    private HawkularPipeline<?, Element> navigate(CanonicalPath path) {
        HawkularPipeline ret = new HawkularPipeline(this.context.getGraph());
        if (path.getRelationshipId() != null) {
            ret.E().hasEid(path.getRelationshipId());
            return ret;
        }
        if (path.getTenantId() != null) {
            ret.V().hasType(Constants.Type.tenant).hasEid(path.getTenantId());
            if (path.getEnvironmentId() != null) {
                ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.environment).hasEid(path.getEnvironmentId());
                if (path.getFeedId() != null) {
                    ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.feed).hasEid(path.getFeedId());
                    if (path.getMetricId() != null) {
                        ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.metric).hasEid(path.getMetricId());
                        return ret;
                    }
                    if (path.getResourceId() != null) {
                        ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.resource).hasEid(path.getResourceId());
                        return ret;
                    }
                    return ret;
                }
                if (path.getMetricId() != null) {
                    ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.metric).hasEid(path.getMetricId());
                    return ret;
                }
                if (path.getResourceId() != null) {
                    ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.resource).hasEid(path.getResourceId());
                    return ret;
                }
                return ret;
            }
            if (path.getMetricTypeId() != null) {
                ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.metricType).hasEid(path.getMetricTypeId());
                return ret;
            }
            if (path.getResourceTypeId() != null) {
                ret.out(Relationships.WellKnown.contains).hasType(Constants.Type.resourceType).hasEid(path.getResourceTypeId());
                return ret;
            }
            return ret;
        }
        throw new IllegalArgumentException("Unexpected canonical path: " + path);
    }

    static void checkProperties(Map<String, Object> properties, String[] disallowedProperties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashSet<String> disallowed = new HashSet<String>(properties.keySet());
        disallowed.retainAll(Arrays.asList(disallowedProperties));
        if (!disallowed.isEmpty()) {
            throw new IllegalArgumentException("The following properties are reserved for this type of entity: " + Arrays.asList(disallowedProperties));
        }
    }

    static void updateProperties(Element e, Map<String, Object> properties, String[] disallowedProperties) {
        String[] toRemove;
        HashSet<String> disallowed = new HashSet<String>(Arrays.asList(disallowedProperties));
        for (String p2 : toRemove = (String[])e.getPropertyKeys().stream().filter(p -> !disallowed.contains(p) && !properties.containsKey(p)).toArray(String[]::new)) {
            e.removeProperty(p2);
        }
        properties.forEach((p, v) -> {
            if (!disallowed.contains(p)) {
                e.setProperty(p, v);
            }
        });
    }

    static Vertex getTenantVertexOf(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case environment: 
            case metricType: 
            case resourceType: {
                return (Vertex)entityVertex.getVertices(Direction.IN, new String[]{Relationships.WellKnown.contains.name()}).iterator().next();
            }
            case feed: 
            case metric: 
            case resource: {
                return TinkerpopBackend.getTenantVertexOf(TinkerpopBackend.getEnvironmentVertexOf(entityVertex));
            }
        }
        return null;
    }

    static Vertex getEnvironmentVertexOf(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case feed: 
            case metric: 
            case resource: {
                return (Vertex)new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.environment).iterator().next();
            }
        }
        return null;
    }

    static Vertex getEnvironmentVertexOrNull(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case feed: 
            case metric: 
            case resource: {
                Iterator envs = new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.environment).iterator();
                if (envs.hasNext()) {
                    return (Vertex)envs.next();
                }
                return null;
            }
        }
        return null;
    }

    static Vertex getFeedVertexOrNull(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case metric: 
            case resource: {
                Iterator feeds = new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.feed).iterator();
                if (feeds.hasNext()) {
                    return (Vertex)feeds.next();
                }
                return null;
            }
        }
        return null;
    }

    static Constants.Type getType(Vertex v) {
        return Constants.Type.valueOf((String)v.getProperty(Constants.Property.__type.name()));
    }

    static String getEid(Element e) {
        return (String)e.getProperty(Constants.Property.__eid.name());
    }

    static Direction toNative(Relationships.Direction direction) {
        return direction == Relationships.Direction.incoming ? Direction.IN : (direction == Relationships.Direction.outgoing ? Direction.OUT : Direction.BOTH);
    }
}

