/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.util.ServiceLoader;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.TinkerpopBackend;
import org.hawkular.inventory.impl.tinkerpop.spi.GraphProvider;
import org.hawkular.inventory.impl.tinkerpop.spi.IndexSpec;

public final class TinkerpopInventory
extends BaseInventory<Element> {
    protected InventoryBackend<Element> doInitialize(Configuration configuration) {
        InventoryContext context = this.loadGraph(configuration);
        return new TinkerpopBackend(context);
    }

    private <T extends TransactionalGraph> InventoryContext<T> loadGraph(Configuration configuration) {
        GraphProvider gp = ServiceLoader.load(GraphProvider.class).iterator().next();
        T g = this.ensureIndices(gp, configuration);
        return new InventoryContext<T>(this, g, gp);
    }

    private <T extends TransactionalGraph> T ensureIndices(GraphProvider<T> graphProvider, Configuration config) {
        TransactionalGraph graph = graphProvider.instantiateGraph(config);
        graphProvider.ensureIndices(graph, new IndexSpec[]{IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).withProperty(Constants.Property.__eid.name(), String.class).build(), IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).build()});
        return (T)graph;
    }
}

