/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import java.util.Arrays;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;

final class Constants {
    private Constants() {
    }

    static enum Type {
        tenant(Tenant.class, new Property[0]),
        environment(Environment.class, new Property[0]),
        feed(Feed.class, new Property[0]),
        resourceType(ResourceType.class, new Property[0]),
        metricType(MetricType.class, Property.__unit, Property.__metric_data_type),
        resource(Resource.class, new Property[0]),
        metric(Metric.class, new Property[0]),
        relationship(Relationship.class, new Property[0]);

        private final String[] mappedProperties;
        private final Class<? extends AbstractElement<?, ?>> entityType;

        private Type(Class<? extends AbstractElement<?, ?>> entityType, Property ... mappedProperties) {
            this.entityType = entityType;
            this.mappedProperties = new String[mappedProperties.length + 3];
            Arrays.setAll(this.mappedProperties, i -> {
                switch (i) {
                    case 0: {
                        return Property.__type.name();
                    }
                    case 1: {
                        return Property.__eid.name();
                    }
                    case 2: {
                        return Property.__cp.name();
                    }
                }
                return mappedProperties[i - 3].name();
            });
        }

        public static Type of(AbstractElement<?, ?> e) {
            return (Type)((Object)e.accept((ElementVisitor)new ElementVisitor.Simple<Type, Void>(){

                public Type visitRelationship(Relationship relationship, Void parameter) {
                    return Type.relationship;
                }

                public Type visitTenant(Tenant tenant, Void parameter) {
                    return Type.tenant;
                }

                public Type visitEnvironment(Environment environment, Void parameter) {
                    return Type.environment;
                }

                public Type visitFeed(Feed feed, Void parameter) {
                    return Type.feed;
                }

                public Type visitMetric(Metric metric, Void parameter) {
                    return Type.metric;
                }

                public Type visitMetricType(MetricType definition, Void parameter) {
                    return metricType;
                }

                public Type visitResource(Resource resource, Void parameter) {
                    return Type.resource;
                }

                public Type visitResourceType(ResourceType type, Void parameter) {
                    return resourceType;
                }
            }, null));
        }

        public static Type of(final Class<?> ec) {
            return (Type)((Object)ElementTypeVisitor.accept(ec, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Type, Void>(){

                public Type visitTenant(Void parameter) {
                    return tenant;
                }

                public Type visitEnvironment(Void parameter) {
                    return environment;
                }

                public Type visitFeed(Void parameter) {
                    return feed;
                }

                public Type visitMetric(Void parameter) {
                    return metric;
                }

                public Type visitMetricType(Void parameter) {
                    return metricType;
                }

                public Type visitResource(Void parameter) {
                    return resource;
                }

                public Type visitResourceType(Void parameter) {
                    return resourceType;
                }

                public Type visitRelationship(Void parameter) {
                    return relationship;
                }

                public Type visitUnknown(Void parameter) {
                    throw new IllegalArgumentException("Unsupported entity class " + ec);
                }
            }, null));
        }

        public Class<? extends AbstractElement<?, ?>> getEntityType() {
            return this.entityType;
        }

        public String[] getMappedProperties() {
            return this.mappedProperties;
        }
    }

    static enum Property {
        __type,
        __eid,
        __unit,
        __metric_data_type,
        __cp;


        public static String mapUserDefined(String property) {
            if ("id".equals(property)) {
                return __eid.name();
            }
            return property;
        }
    }
}

