/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.util.PipeHelper;

class DrainedRangeFilterPipe<S>
extends AbstractPipe<S, S>
implements FilterPipe<S> {
    private final int low;
    private final int high;
    private int counter = -1;

    public DrainedRangeFilterPipe(int low, int high) {
        this.low = low;
        this.high = high;
        if (this.low != -1 && this.high != -1 && this.low > this.high) {
            throw new IllegalArgumentException("Not a legal range: [" + low + ", " + high + "]");
        }
    }

    protected S processNextStart() {
        Object s;
        do {
            s = this.starts.next();
            ++this.counter;
        } while (this.low != -1 && this.counter < this.low || this.high != -1 && this.counter > this.high);
        return (S)s;
    }

    public String toString() {
        return PipeHelper.makePipeString((Pipe)this, (Object[])new Object[]{this.low, this.high});
    }

    public void reset() {
        this.counter = -1;
        super.reset();
    }

    public int getHighRange() {
        return this.high;
    }

    public int getLowRange() {
        return this.low;
    }
}

