/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.util.ServiceLoader;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.Log;
import org.hawkular.inventory.impl.tinkerpop.TinkerpopBackend;
import org.hawkular.inventory.impl.tinkerpop.spi.GraphProvider;
import org.hawkular.inventory.impl.tinkerpop.spi.IndexSpec;

public final class TinkerpopInventory
extends BaseInventory<Element> {
    public static final Configuration.Property GRAPH_PROVIDER_IMPL_CLASS = Configuration.Property.builder().withPropertyNameAndSystemProperty("hawkular.inventory.tinkerpop.graph-provider-impl").withEnvironmentVariables(new String[]{"HAWKULAR_INVENTORY_TINKERPOP_GRAPH_PROVIDER_IMPL"}).build();

    protected InventoryBackend<Element> doInitialize(Configuration configuration) {
        InventoryContext context = this.loadGraph(configuration);
        return new TinkerpopBackend(context);
    }

    private <T extends TransactionalGraph> InventoryContext<T> loadGraph(Configuration configuration) {
        GraphProvider<?> gp = this.instantiateGraphProvider(configuration);
        Log.LOG.iUsingGraphProvider(gp.getClass().getName());
        Object g = this.ensureIndices(gp, configuration);
        return new InventoryContext(this, g, gp);
    }

    private <T extends TransactionalGraph> T ensureIndices(GraphProvider<T> graphProvider, Configuration config) {
        TransactionalGraph graph = graphProvider.instantiateGraph(config);
        graphProvider.ensureIndices(graph, new IndexSpec[]{IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).withProperty(Constants.Property.__eid.name(), String.class).build(), IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).build()});
        IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).withProperty(Constants.Property.__metric_data_type.name(), String.class).build();
        return (T)graph;
    }

    private GraphProvider<?> instantiateGraphProvider(Configuration config) {
        String implClass = config.getProperty(GRAPH_PROVIDER_IMPL_CLASS, null);
        if (implClass != null) {
            try {
                return (GraphProvider)Class.forName(implClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Could not instantiate graph provider class '" + implClass + "'.", e);
            }
        }
        return ServiceLoader.load(GraphProvider.class).iterator().next();
    }
}

