/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.TreeTraversal;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ContentHashable;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.IdentityHashable;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Syncable;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;

public class BasePreCommit<BE>
implements Transaction.PreCommit<BE> {
    private final List<EntityAndPendingNotifications<BE, ?>> nonHashedChanges = new ArrayList();
    private final List<Consumer<Transaction<BE>>> explicitActions = new ArrayList<Consumer<Transaction<BE>>>();
    private final List<EntityAndPendingNotifications<BE, ?>> correctedChanges = new ArrayList();
    private final ProcessingTree<BE> processingTree = new ProcessingTree();
    private Inventory inventory;
    private Transaction<BE> tx;
    private Consumer<Transaction<BE>> correctiveAction;

    @Override
    public void initialize(Inventory inventory, Transaction<BE> tx) {
        this.inventory = inventory;
        this.tx = tx;
    }

    @Override
    public void reset() {
        this.nonHashedChanges.clear();
        this.explicitActions.clear();
        this.correctiveAction = null;
        this.correctedChanges.clear();
        this.processingTree.clear();
    }

    @Override
    public List<EntityAndPendingNotifications<BE, ?>> getFinalNotifications() {
        ArrayList ret = new ArrayList(this.nonHashedChanges);
        ret.addAll(this.correctedChanges);
        return ret;
    }

    @Override
    public void addAction(Consumer<Transaction<BE>> action) {
        this.explicitActions.add(action);
    }

    @Override
    public List<Consumer<Transaction<BE>>> getActions() {
        List<Consumer<Transaction<BE>>> ret;
        this.process();
        if (this.correctiveAction != null) {
            ret = new ArrayList<Consumer<Transaction<BE>>>(this.explicitActions);
            ret.add(this.correctiveAction);
        } else {
            ret = this.explicitActions;
        }
        return ret;
    }

    @Override
    public void addNotifications(EntityAndPendingNotifications<BE, ?> element) {
        if (this.needsProcessing(element)) {
            this.processingTree.add(element);
        } else {
            this.nonHashedChanges.add(element);
        }
    }

    @Override
    public void addProcessedNotifications(EntityAndPendingNotifications<BE, ?> element) {
        this.nonHashedChanges.add(element);
    }

    private boolean needsProcessing(EntityAndPendingNotifications<?, ?> element) {
        return !(element.getEntity() instanceof Relationship);
    }

    private void process() {
        ArrayList syncHashRoots = new ArrayList();
        this.processingTree.dfsTraversal(t -> {
            syncHashRoots.add(t);
            return !t.canBeIdentityRoot();
        });
        if (syncHashRoots.isEmpty()) {
            this.correctiveAction = null;
            return;
        }
        this.correctiveAction = t -> this.processingTree.children.forEach(c -> this.correctChanges((ProcessingTree<BE>)c, true));
    }

    private void correctChanges(ProcessingTree<BE> changedEntity, boolean computeHashes) {
        if (this.__correctChangesPrologue(changedEntity)) {
            return;
        }
        Entity e = (Entity)changedEntity.element;
        Hashes.Tree treeHash = computeHashes ? Hashes.treeOf(InventoryStructure.of(e, this.inventory), e.getPath()) : Hashes.Tree.builder().build();
        this.__correctChangesNoPrologue(changedEntity, treeHash);
    }

    private void correctChanges(ProcessingTree<BE> changedEntity, Hashes.Tree newHash) {
        if (this.__correctChangesPrologue(changedEntity)) {
            return;
        }
        this.__correctChangesNoPrologue(changedEntity, newHash);
    }

    private void __correctChangesNoPrologue(ProcessingTree<BE> changedEntity, Hashes.Tree newHash) {
        if (changedEntity.element instanceof Syncable || changedEntity.element instanceof IdentityHashable) {
            this.correctHierarchicalHashChanges(newHash, changedEntity);
        } else {
            this.correctNonHierarchicalHashChanges((Hashes)newHash.getHash(), changedEntity);
        }
    }

    private boolean __correctChangesPrologue(ProcessingTree<BE> changedEntity) {
        if (changedEntity.cp == null) {
            return false;
        }
        if (!Entity.Blueprint.class.isAssignableFrom(Inventory.types().bySegment(changedEntity.cp.getSegment().getElementType()).getBlueprintType())) {
            return true;
        }
        try {
            changedEntity.loadFrom(this.tx);
        }
        catch (ElementNotFoundException e) {
            if (this.processDeletion(changedEntity, changedEntity.notifications)) {
                return true;
            }
            throw new EntityNotFoundException(Query.filters(Query.to(changedEntity.cp)));
        }
        return this.processDeletion(changedEntity, changedEntity.notifications);
    }

    private void correctNonHierarchicalHashChanges(Hashes hashes, ProcessingTree<BE> changedEntity) {
        Entity e = (Entity)changedEntity.element;
        this.addHashChangeNotifications(changedEntity.element, hashes, changedEntity.notifications);
        this.tx.updateHashes(changedEntity.representation, hashes);
        this.correctedChanges.add(new EntityAndPendingNotifications(changedEntity.representation, e, changedEntity.notifications));
        changedEntity.children.forEach(c -> this.correctChanges((ProcessingTree<BE>)c, true));
    }

    private void correctHierarchicalHashChanges(Hashes.Tree treeHash, ProcessingTree<BE> changesTree) {
        Entity<?, ?> e = this.cloneWithHash((Entity)changesTree.element, (Hashes)treeHash.getHash());
        List<Notification<?, ?>> ns = changesTree.notifications.stream().map(n -> this.cloneWithNewEntity((Notification<?, ?>)n, (AbstractElement<?, ?>)e)).collect(Collectors.toList());
        Hashes origHash = this.hashesOf(changesTree.element);
        if (!Objects.equals(origHash, treeHash.getHash())) {
            Optional<Notification> createNotif = ns.stream().filter(n -> n.getAction() == Action.created() && n.getValue().equals(changesTree.element)).findAny();
            if (!createNotif.isPresent()) {
                if (origHash == null) {
                    ns.add(new Notification(changesTree.element, changesTree.element, Action.created()));
                } else {
                    this.addHashChangeNotifications(changesTree.element, (Hashes)treeHash.getHash(), ns);
                }
            }
            this.tx.updateHashes(changesTree.representation, (Hashes)treeHash.getHash());
        }
        this.correctedChanges.add(new EntityAndPendingNotifications(changesTree.representation, e, ns));
        ArrayList treeChildren = new ArrayList(treeHash.getChildren());
        Collections.sort(treeChildren, (a, b) -> a.getPath().getSegment().getElementId().compareTo(b.getPath().getSegment().getElementId()));
        ArrayList processedChildren = new ArrayList(changesTree.children);
        Collections.sort(processedChildren, (a, b) -> a.path.getElementId().compareTo(b.path.getElementId()));
        int i = 0;
        int j = 0;
        while (i < processedChildren.size() && j < treeChildren.size()) {
            ProcessingTree p = processedChildren.get(i);
            Hashes.Tree h = (Hashes.Tree)treeChildren.get(j);
            int cmp = p.path.getElementId().compareTo(h.getPath().getSegment().getElementId());
            if (cmp == 0) {
                this.correctChanges(p, h);
                ++i;
                ++j;
                continue;
            }
            if (cmp > 0) {
                ++j;
                continue;
            }
            ++i;
            if (!p.canBeIdentityRoot() || this.processDeletion(p, p.notifications)) continue;
            throw new IllegalStateException("Entity on path " + p.element.getPath() + " requires identity hash re-computation" + " but was not found contributing to a tree hash of a parent. This is" + " inconsistency in the inventory model and a bug.");
        }
        for (i = treeChildren.size(); i < processedChildren.size(); ++i) {
            this.correctChanges(processedChildren.get(i), true);
        }
    }

    private void addHashChangeNotifications(AbstractElement<?, ?> entity, Hashes newHashes, List<Notification<?, ?>> notifications) {
        Object el;
        if (entity instanceof Syncable && !Objects.equals((el = (Syncable)((Object)entity)).getSyncHash(), newHashes.getSyncHash())) {
            notifications.add(new Notification<Object, Object>(el, el, Action.syncHashChanged()));
        }
        if (entity instanceof ContentHashable && !Objects.equals((el = (ContentHashable)((Object)entity)).getContentHash(), newHashes.getContentHash())) {
            notifications.add(new Notification<Object, Object>(el, el, Action.contentHashChanged()));
        }
        if (entity instanceof IdentityHashable && !Objects.equals((el = (IdentityHashable)((Object)entity)).getIdentityHash(), newHashes.getIdentityHash())) {
            notifications.add(new Notification<Object, Object>(el, el, Action.identityHashChanged()));
        }
    }

    private Hashes hashesOf(AbstractElement<?, ?> el) {
        String contentHash = null;
        String identityHash = null;
        String syncHash = null;
        if (el instanceof ContentHashable) {
            contentHash = ((ContentHashable)((Object)el)).getContentHash();
        }
        if (el instanceof IdentityHashable) {
            identityHash = ((IdentityHashable)((Object)el)).getIdentityHash();
        }
        if (el instanceof Syncable) {
            syncHash = ((Syncable)((Object)el)).getSyncHash();
        }
        return contentHash == null && identityHash == null && syncHash == null ? null : new Hashes(identityHash, contentHash, syncHash);
    }

    private boolean processDeletion(ProcessingTree<BE> changesTree, List<Notification<?, ?>> ns) {
        Optional<Notification> deleteNotification = ns.stream().filter(n -> n.getAction() == Action.deleted() && n.getValue() instanceof AbstractElement).filter(n -> ((AbstractElement)n.getValue()).getPath().equals((Object)changesTree.cp)).findAny();
        if (deleteNotification.isPresent()) {
            Notification n2 = deleteNotification.get();
            this.correctedChanges.add(new EntityAndPendingNotifications<Object, AbstractElement>(null, (AbstractElement)n2.getValue(), ns));
            changesTree.dfsTraversal(pt -> {
                this.correctChanges((ProcessingTree<BE>)pt, false);
                return true;
            });
            return true;
        }
        return false;
    }

    private Entity<?, ?> cloneWithHash(final Entity<?, ?> entity, final Hashes hashes) {
        if (hashes == null) {
            return entity;
        }
        return (Entity)entity.accept(new ElementVisitor.Simple<Entity<?, ?>, Void>(){

            @Override
            protected Entity<?, ?> defaultAction() {
                if (entity instanceof IdentityHashable) {
                    throw new IllegalStateException("Unhandled IdentityHashable type: " + entity);
                }
                return entity;
            }

            @Override
            public Entity<?, ?> visitData(DataEntity data, Void parameter) {
                return new DataEntity(data.getPath(), data.getValue(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), data.getProperties());
            }

            @Override
            public Entity<?, ?> visitFeed(Feed feed, Void parameter) {
                return new Feed(feed.getName(), feed.getPath(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), feed.getProperties());
            }

            @Override
            public Entity<?, ?> visitMetric(Metric metric, Void parameter) {
                return new Metric(metric.getName(), metric.getPath(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), metric.getType(), metric.getCollectionInterval(), metric.getProperties());
            }

            @Override
            public Entity<?, ?> visitMetricType(MetricType type, Void parameter) {
                return new MetricType(type.getName(), type.getPath(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), type.getUnit(), type.getMetricDataType(), type.getProperties(), type.getCollectionInterval());
            }

            @Override
            public Entity<?, ?> visitOperationType(OperationType operationType, Void parameter) {
                return new OperationType(operationType.getName(), operationType.getPath(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), operationType.getProperties());
            }

            @Override
            public Entity<?, ?> visitResource(Resource resource, Void parameter) {
                return new Resource(resource.getName(), resource.getPath(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), resource.getType(), resource.getProperties());
            }

            @Override
            public Entity<?, ?> visitResourceType(ResourceType type, Void parameter) {
                return new ResourceType(type.getName(), type.getPath(), hashes.getIdentityHash(), hashes.getContentHash(), hashes.getSyncHash(), type.getProperties());
            }
        }, null);
    }

    private Notification<?, ?> cloneWithNewEntity(Notification<?, ?> notif, AbstractElement<?, ?> element) {
        if (!(notif.getValue() instanceof AbstractElement)) {
            return notif;
        }
        Object context = notif.getActionContext();
        Object value = notif.getValue();
        if (context instanceof AbstractElement && element.getPath().equals((Object)((AbstractElement)context).getPath())) {
            context = element;
        }
        if (element.getPath().equals((Object)((AbstractElement)value).getPath())) {
            value = element;
        }
        return new Notification(context, value, notif.getAction());
    }

    private static class ProcessingTree<BE> {
        final Set<ProcessingTree<BE>> children = new HashSet<ProcessingTree<BE>>(2);
        final Path.Segment path;
        final CanonicalPath cp;
        final List<Notification<?, ?>> notifications;
        AbstractElement<?, ?> element = null;
        BE representation = null;
        private Transaction<BE> loadingTx;

        ProcessingTree() {
            this(null, null);
        }

        private ProcessingTree(Path.Segment path, CanonicalPath cp) {
            this.path = path;
            this.cp = cp;
            this.notifications = new ArrayList(0);
            this.clear();
        }

        void clear() {
            this.children.clear();
        }

        private static boolean canBeIdentityRoot(SegmentType segmentType) {
            return IdentityHashable.class.isAssignableFrom(Inventory.types().bySegment(segmentType).getElementType());
        }

        boolean canBeIdentityRoot() {
            return ProcessingTree.canBeIdentityRoot(this.path.getElementType());
        }

        void loadFrom(Transaction<BE> tx) throws ElementNotFoundException {
            if (this.element == null || this.loadingTx != tx) {
                this.loadingTx = tx;
                this.representation = tx.find(this.cp);
                Class<?> type = tx.extractType(this.representation);
                this.element = (AbstractElement)tx.convert(this.representation, type);
            }
        }

        void add(EntityAndPendingNotifications<BE, ?> entity) {
            if (this.path != null) {
                throw new IllegalStateException("Cannot add element to partial results from a non-root segment.");
            }
            ProcessingTree<BE> found = this.extendTreeTo(((AbstractElement)entity.getEntity()).getPath());
            found.representation = entity.getEntityRepresentation();
            found.element = entity.getEntity();
            found.notifications.addAll(entity.getNotifications());
        }

        private ProcessingTree<BE> extendTreeTo(CanonicalPath entityPath) {
            Set<ProcessingTree<BE>> children = this.children;
            CanonicalPath.Extender cp = CanonicalPath.empty();
            ProcessingTree<BE> found = null;
            for (Path.Segment seg : entityPath.getPath()) {
                cp.extend(seg);
                found = null;
                for (ProcessingTree<BE> child : children) {
                    if (!seg.equals((Object)child.path)) continue;
                    found = child;
                    break;
                }
                if (found == null) {
                    found = new ProcessingTree<BE>(seg, cp.get());
                    children.add(found);
                }
                children = found.children;
            }
            if (found == null) {
                throw new IllegalStateException("Could not figure out the processing tree element for entity on path " + entityPath);
            }
            return found;
        }

        void dfsTraversal(Function<ProcessingTree<BE>, Boolean> visitor) {
            TreeTraversal<ProcessingTree> traversal = new TreeTraversal<ProcessingTree>(t -> t.children.iterator());
            traversal.depthFirst(this, t -> {
                if (t == this) {
                    return true;
                }
                return (Boolean)visitor.apply((ProcessingTree<BE>)t);
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessingTree that = (ProcessingTree)o;
            return this.path.equals((Object)that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

