/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.Configuration;
import javax.validation.ConstraintViolationException;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.JCATraversableResolver;
import org.jboss.logging.Logger;

public class BeanValidation {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)BeanValidation.class.getName());
    private static String factoryName = "java:/ValidatorFactory";
    private volatile ValidatorFactory factory;

    public BeanValidation() {
        this(null);
    }

    public BeanValidation(ValidatorFactory vf) {
        this.factory = vf;
    }

    public void validate(Object object, List<Class> groupsClasses) throws ConstraintViolationException {
        if (object == null) {
            throw new IllegalArgumentException("Object is null");
        }
        if (this.factory == null) {
            this.initValidatorFactory();
        }
        Validator v = this.factory.usingContext().traversableResolver((TraversableResolver)new JCATraversableResolver()).getValidator();
        Set errors = null;
        if (groupsClasses == null || groupsClasses.size() == 0) {
            log.tracef("Validating: %s against groups %s", object, Default.class.getName());
            errors = v.validate(object, new Class[]{Default.class});
        } else {
            Object[] vargs = groupsClasses.toArray(new Class[groupsClasses.size()]);
            if (log.isTraceEnabled()) {
                log.tracef("Validating: %s against groups %s", object, Arrays.toString(vargs));
            }
            errors = v.validate(object, (Class[])vargs);
        }
        if (errors != null && errors.size() > 0) {
            throw new ConstraintViolationException(errors);
        }
    }

    public static void setValidatorFactoryName(String name) {
        factoryName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initValidatorFactory() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            this.factory = (ValidatorFactory)context.lookup(factoryName);
        }
        catch (Throwable t) {
            Configuration configuration = Validation.byDefaultProvider().configure();
            Configuration conf = configuration.traversableResolver((TraversableResolver)new JCATraversableResolver());
            this.factory = conf.buildValidatorFactory();
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException ne) {}
        }
    }
}

