/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionDetail;

public class CoreTransactionDetail
extends TransactionDetail {
    public CoreTransactionDetail(Xid xid, Transaction tx, Long creation) throws Exception {
        super(xid, tx, creation);
    }

    @Override
    public String decodeMessageType(ServerMessage msg) {
        byte type = msg.getType();
        switch (type) {
            case 0: {
                return "Default";
            }
            case 2: {
                return "ObjectMessage";
            }
            case 3: {
                return "TextMessage";
            }
            case 4: {
                return "ByteMessage";
            }
            case 5: {
                return "MapMessage";
            }
            case 6: {
                return "StreamMessage";
            }
        }
        return "(Unknown Type)";
    }

    @Override
    public Map<String, Object> decodeMessageProperties(ServerMessage msg) {
        return msg.toMap();
    }
}

