/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.walkers;

import java.net.URL;
import org.hawkular.agent.prometheus.Util;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.MetricType;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;

public class XMLPrometheusMetricsWalker
implements PrometheusMetricsWalker {
    private final URL url;

    public XMLPrometheusMetricsWalker() {
        this(null);
    }

    public XMLPrometheusMetricsWalker(URL url) {
        this.url = url;
    }

    @Override
    public void walkStart() {
        System.out.printf("<metricFamilies>\n", new Object[0]);
        if (this.url != null) {
            System.out.printf("  <url>%s</url>\n", this.url);
        }
    }

    @Override
    public void walkFinish(int familiesProcessed, int metricsProcessed) {
        if (familiesProcessed > 0) {
            System.out.printf("  </metricFamily>\n", new Object[0]);
        }
        System.out.println("</metricFamilies>");
    }

    @Override
    public void walkMetricFamily(MetricFamily family, int index) {
        if (index > 0) {
            System.out.printf("  </metricFamily>\n", new Object[0]);
        }
        System.out.printf("  <metricFamily>\n", new Object[0]);
        System.out.printf("    <name>%s</name>\n", family.getName());
        System.out.printf("    <type>%s</type>\n", new Object[]{family.getType()});
        System.out.printf("    <help>%s</help>\n", family.getHelp());
    }

    @Override
    public void walkCounterMetric(MetricFamily family, Counter metric, int index) {
        System.out.printf("    <metric>\n", new Object[0]);
        System.out.printf("      <name>%s</name>\n", family.getName());
        System.out.printf("      <type>%s</type>\n", new Object[]{MetricType.COUNTER});
        System.out.printf("      <labels>%s</labels>\n", this.buildLabelListString(metric.getLabels(), null, null));
        System.out.printf("      <value>%s</value>\n", Util.convertDoubleToString(metric.getValue()));
        System.out.printf("    </metric>\n", new Object[0]);
    }

    @Override
    public void walkGaugeMetric(MetricFamily family, Gauge metric, int index) {
        System.out.printf("    <metric>\n", new Object[0]);
        System.out.printf("      <name>%s</name>\n", family.getName());
        System.out.printf("      <type>%s</type>\n", new Object[]{MetricType.GAUGE});
        System.out.printf("      <labels>%s</labels>\n", this.buildLabelListString(metric.getLabels(), null, null));
        System.out.printf("      <value>%s</value>\n", Util.convertDoubleToString(metric.getValue()));
        System.out.printf("    </metric>\n", new Object[0]);
    }

    @Override
    public void walkSummaryMetric(MetricFamily family, Summary metric, int index) {
        System.out.printf("    <metric>\n", new Object[0]);
        System.out.printf("      <name>%s</name>\n", family.getName());
        System.out.printf("      <type>%s</type>\n", new Object[]{MetricType.SUMMARY});
        System.out.printf("      <labels>%s</labels>\n", this.buildLabelListString(metric.getLabels(), null, null));
        System.out.printf("      <count>%d</count>\n", metric.getSampleCount());
        System.out.printf("      <sum>%s</sum>\n", Util.convertDoubleToString(metric.getSampleSum()));
        if (!metric.getQuantiles().isEmpty()) {
            System.out.printf("      <quantiles>\n", new Object[0]);
            for (Summary.Quantile quantile : metric.getQuantiles()) {
                System.out.printf("        <quantile>%s</quantile>\n", quantile);
            }
            System.out.printf("      </quantiles>\n", new Object[0]);
        }
        System.out.printf("    </metric>\n", new Object[0]);
    }

    @Override
    public void walkHistogramMetric(MetricFamily family, Histogram metric, int index) {
        System.out.printf("    <metric>\n", new Object[0]);
        System.out.printf("      <name>%s</name>\n", family.getName());
        System.out.printf("      <type>%s</type>\n", new Object[]{MetricType.HISTOGRAM});
        System.out.printf("      <labels>%s</labels>\n", this.buildLabelListString(metric.getLabels(), null, null));
        System.out.printf("      <count>%d</count>\n", metric.getSampleCount());
        System.out.printf("      <sum>%s</sum>\n", Util.convertDoubleToString(metric.getSampleSum()));
        if (!metric.getBuckets().isEmpty()) {
            System.out.printf("      <buckets>\n", new Object[0]);
            for (Histogram.Bucket bucket : metric.getBuckets()) {
                System.out.printf("        <bucket>%s</bucket>\n", bucket);
            }
            System.out.printf("      </bucket>\n", new Object[0]);
        }
        System.out.printf("    </metric>\n", new Object[0]);
    }
}

