/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol;

import java.util.Collection;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.dynamicprotocol.MetricMetadata;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.service.ServiceStatus;

public abstract class DynamicEndpointService
implements Runnable {
    private static final MsgLogger LOG = AgentLoggers.getLogger(DynamicEndpointService.class);
    private final MonitoredEndpoint<MonitorServiceConfiguration.DynamicEndpointConfiguration> endpoint;
    private final String feedId;
    private final HawkularWildFlyAgentContext hawkularStorage;
    private final Collection<MetricMetadata> metrics;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public DynamicEndpointService(String feedId, MonitoredEndpoint<MonitorServiceConfiguration.DynamicEndpointConfiguration> endpoint, HawkularWildFlyAgentContext hawkularStorage, Collection<MetricMetadata> metrics) {
        this.feedId = feedId;
        this.endpoint = endpoint;
        this.hawkularStorage = hawkularStorage;
        this.metrics = metrics;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public MonitoredEndpoint<MonitorServiceConfiguration.DynamicEndpointConfiguration> getMonitoredEndpoint() {
        return this.endpoint;
    }

    public HawkularWildFlyAgentContext getHawkularStorage() {
        return this.hawkularStorage;
    }

    public Collection<MetricMetadata> getMetrics() {
        return this.metrics;
    }

    public void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        this.status = ServiceStatus.RUNNING;
        LOG.debugf("Started [%s]", this.toString());
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        this.status = ServiceStatus.STOPPED;
        LOG.debugf("Stopped [%s]", this.toString());
    }

    @Override
    public abstract void run();

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getMonitoredEndpoint());
    }

    public int hashCode() {
        int result = 31 + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DynamicEndpointService)) {
            return false;
        }
        DynamicEndpointService other = (DynamicEndpointService)obj;
        return !(this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint));
    }
}

