/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class FileStoreBuilder
extends StoreBuilder {
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private volatile SingleFileStoreConfigurationBuilder builder;
    private volatile String relativePath;
    private volatile String relativeTo;

    FileStoreBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
        this.relativePath = "infinispan" + File.separatorChar + containerName;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, this.pathManager);
    }

    @Override
    public PersistenceConfiguration getValue() {
        this.builder.location(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.relativePath, this.relativeTo));
        return super.getValue();
    }

    @Override
    StoreConfigurationBuilder<?, ?> createStore(OperationContext context, ModelNode model) throws OperationFailedException {
        String relativePath = ModelNodes.asString((ModelNode)FileStoreResourceDefinition.Attribute.RELATIVE_PATH.getDefinition().resolveModelAttribute(context, model));
        if (relativePath != null) {
            this.relativePath = relativePath;
        }
        this.relativeTo = FileStoreResourceDefinition.Attribute.RELATIVE_TO.getDefinition().resolveModelAttribute(context, model).asString();
        this.builder = new ConfigurationBuilder().persistence().addSingleFileStore();
        return this.builder;
    }
}

