/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Field;
import org.jboss.msc.value.Value;

public final class FieldValue<T>
implements Value<T> {
    private final Field field;
    private final Value<?> targetValue;

    public FieldValue(Field field, Value<?> targetValue) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        if (targetValue == null) {
            throw new IllegalArgumentException("targetValue is null");
        }
        this.field = field;
        this.targetValue = targetValue;
    }

    @Override
    public T getValue() throws IllegalStateException {
        try {
            return (T)this.field.get(this.targetValue.getValue());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Field is not accessible", e);
        }
    }
}

