/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.configuration.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class MaskedProperty
extends Properties
implements Serializable {
    private static final long serialVersionUID = -593307257383085113L;
    private static final Log log = LoggerFactory.make();
    private final Properties masked;
    private final Properties fallBack;
    private final String radix;
    private transient Set<Object> propertyNames;

    public MaskedProperty(Properties propsToMask, String mask) {
        this(propsToMask, mask, null);
    }

    public MaskedProperty(Properties propsToMask, String mask, Properties propsFallBack) {
        if (propsToMask == null || mask == null) {
            throw new IllegalArgumentException();
        }
        this.masked = propsToMask;
        this.radix = mask + ".";
        this.fallBack = propsFallBack;
    }

    @Override
    public String getProperty(String key) {
        String compositeKey = this.radix + key;
        String value = this.masked.getProperty(compositeKey);
        if (value != null) {
            log.tracef("found a match for key: [%s] value: %s", compositeKey, value);
            return value;
        }
        if (this.fallBack != null) {
            return this.fallBack.getProperty(key);
        }
        return null;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        return this.getProperty(key.toString()) != null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public void list(PrintStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Enumeration<?> propertyNames() {
        this.initPropertyNames();
        return Collections.enumeration(this.propertyNames);
    }

    private synchronized void initPropertyNames() {
        if (this.propertyNames != null) {
            return;
        }
        TreeSet<String> maskedProperties = new TreeSet<String>();
        Enumeration<?> maskedNames = this.masked.propertyNames();
        while (maskedNames.hasMoreElements()) {
            String maskedProperty;
            Object key = maskedNames.nextElement();
            if (!String.class.isInstance(key) || !(maskedProperty = (String)key).startsWith(this.radix)) continue;
            maskedProperties.add(maskedProperty.substring(this.radix.length(), maskedProperty.length()));
        }
        if (this.fallBack != null) {
            Enumeration<?> fallBackNames = this.fallBack.propertyNames();
            while (fallBackNames.hasMoreElements()) {
                Object key = fallBackNames.nextElement();
                if (!String.class.isInstance(key)) continue;
                maskedProperties.add((String)key);
            }
        }
        this.propertyNames = Collections.unmodifiableSet(maskedProperties);
    }

    @Override
    public void save(OutputStream out, String comments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean contains(Object value) {
        this.initPropertyNames();
        return this.propertyNames.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<Object> elements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.initPropertyNames();
        return this.propertyNames.isEmpty();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        this.initPropertyNames();
        return Collections.enumeration(this.propertyNames);
    }

    @Override
    public synchronized Set<Object> keySet() {
        this.initPropertyNames();
        return this.propertyNames;
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rehash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        this.initPropertyNames();
        return this.propertyNames.size();
    }

    @Override
    public synchronized String toString() {
        HashMap fake = new HashMap();
        Enumeration<?> names = this.propertyNames();
        while (names.hasMoreElements()) {
            Object nextElement = names.nextElement();
            fake.put(nextElement, this.getProperty(nextElement.toString()));
        }
        return fake.toString();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = this.fallBack == null ? 0 : this.fallBack.hashCode();
        result = 31 * result + this.masked.hashCode();
        result = 31 * result + this.radix.hashCode();
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaskedProperty other = (MaskedProperty)obj;
        if (this.fallBack == null ? other.fallBack != null : !this.fallBack.equals(other.fallBack)) {
            return false;
        }
        if (!this.masked.equals(other.masked)) {
            return false;
        }
        return this.radix.equals(other.radix);
    }
}

