/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.as.controller.ModelController;
import org.jboss.as.jsr77.logging.JSR77Logger;
import org.jboss.as.jsr77.managedobject.Handler;
import org.jboss.as.jsr77.managedobject.J2EEDeployedObjectHandlers;
import org.jboss.as.jsr77.managedobject.J2EEDomainHandler;
import org.jboss.as.jsr77.managedobject.J2EEServerHandler;
import org.jboss.as.jsr77.managedobject.JVMHandler;
import org.jboss.as.jsr77.managedobject.ModelReader;

public class ManagedObjectHandlerRegistry {
    private final Map<String, Handler> handlers;
    public static final ManagedObjectHandlerRegistry INSTANCE = new ManagedObjectHandlerRegistry();

    private ManagedObjectHandlerRegistry() {
        HashMap<String, Handler> handlers = new HashMap<String, Handler>();
        handlers.put("JVM", JVMHandler.INSTANCE);
        handlers.put("J2EEDomain", J2EEDomainHandler.INSTANCE);
        handlers.put("J2EEServer", J2EEServerHandler.INSTANCE);
        handlers.put("J2EEApplication", J2EEDeployedObjectHandlers.INSTANCE);
        handlers.put("AppClientModule", J2EEDeployedObjectHandlers.INSTANCE);
        handlers.put("EjbModule", J2EEDeployedObjectHandlers.INSTANCE);
        handlers.put("ResourceAdapterModule", J2EEDeployedObjectHandlers.INSTANCE);
        handlers.put("WebModule", J2EEDeployedObjectHandlers.INSTANCE);
        this.handlers = Collections.unmodifiableMap(handlers);
    }

    public boolean isMyDomain(ObjectName objectName) {
        if (!objectName.isDomainPattern()) {
            return objectName.getDomain().equals("jboss.jsr77");
        }
        Pattern p = Pattern.compile(objectName.getDomain().replace("*", ".*"));
        return p.matcher("jboss.jsr77").matches();
    }

    public Set<ObjectName> queryNames(ModelController controller, ObjectName name, QueryExp query) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (Handler handler : this.getHandlers(name)) {
            Set<ObjectName> foundNames = handler.queryObjectNames(new ModelReader(controller), name, query);
            if (name == null) {
                result.addAll(foundNames);
                continue;
            }
            for (ObjectName found : foundNames) {
                if (!name.apply(found)) continue;
                result.add(found);
            }
        }
        return result;
    }

    public Object getAttribute(ModelController controller, ObjectName name, String attribute) throws InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        Handler handler = this.handlers.get(name.getKeyProperty("j2eeType"));
        if (handler == null) {
            throw JSR77Logger.ROOT_LOGGER.noMBeanCalled(name);
        }
        return handler.getAttribute(new ModelReader(controller), name, attribute);
    }

    public int getMBeanCount(ModelController controller) {
        return this.queryNames(controller, null, null).size();
    }

    public boolean isRegistered(ModelController controller, ObjectName name) {
        Handler handler = this.handlers.get(name.getKeyProperty("j2eeType"));
        if (handler == null) {
            return false;
        }
        return handler.queryObjectNames(new ModelReader(controller), name, null).contains(name);
    }

    public MBeanInfo getMBeanInfo(ModelController controller, ObjectName name) throws InstanceNotFoundException {
        Handler handler = this.handlers.get(name.getKeyProperty("j2eeType"));
        if (handler == null) {
            throw JSR77Logger.ROOT_LOGGER.noMBeanCalled(name);
        }
        return handler.getMBeanInfo(new ModelReader(controller), name);
    }

    private Set<Handler> getHandlers(ObjectName name) {
        if (name == null) {
            return this.getHandlersForName(IllAcceptAnythingNameMatcher.INSTANCE);
        }
        if (!this.isMyDomain(name)) {
            return Collections.emptySet();
        }
        String property = name.getKeyProperty("j2eeType");
        if (property != null) {
            if (property.contains("*")) {
                return this.getHandlersForName(new WildcardPatternNameMatcher(Pattern.compile(property.replace("*", ".*"))));
            }
            return this.getHandlersForName(new ExactNameMatcher(property));
        }
        if (name.isPropertyListPattern()) {
            return this.getHandlersForName(IllAcceptAnythingNameMatcher.INSTANCE);
        }
        return Collections.emptySet();
    }

    private Set<Handler> getHandlersForName(NameMatcher matcher) {
        HashSet<Handler> result = null;
        for (Map.Entry<String, Handler> handlerEntry : this.handlers.entrySet()) {
            if (!matcher.matches(handlerEntry.getKey())) continue;
            if (result == null) {
                result = new HashSet<Handler>();
            }
            result.add(handlerEntry.getValue());
        }
        return result == null ? Collections.emptySet() : result;
    }

    private static class WildcardPatternNameMatcher
    implements NameMatcher {
        final Pattern pattern;

        public WildcardPatternNameMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String candidate) {
            return this.pattern.matcher(candidate).matches();
        }
    }

    private static class IllAcceptAnythingNameMatcher
    implements NameMatcher {
        private static final IllAcceptAnythingNameMatcher INSTANCE = new IllAcceptAnythingNameMatcher();

        private IllAcceptAnythingNameMatcher() {
        }

        @Override
        public boolean matches(String candidate) {
            return true;
        }
    }

    private static class ExactNameMatcher
    implements NameMatcher {
        final String search;

        public ExactNameMatcher(String search) {
            this.search = search;
        }

        @Override
        public boolean matches(String candidate) {
            return this.search.matches(candidate);
        }
    }

    private static interface NameMatcher {
        public boolean matches(String var1);
    }
}

