/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.function.Function;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.api.paging.TransformingPage;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.CommitFailureException;

abstract class Fetcher<BE, E extends AbstractElement<?, U>, U extends AbstractElement.Update>
extends Traversal<BE, E>
implements ResolvableToSingle<E, U>,
ResolvableToMany<E> {
    private boolean useCachedEntity = true;

    public Fetcher(TraversalContext<BE, E> context) {
        super(context);
    }

    @Override
    public E entity() throws EntityNotFoundException, RelationNotFoundException {
        if (this.useCachedEntity && this.context.getCreatedEntity() != null) {
            this.useCachedEntity = false;
            return this.context.getCreatedEntity();
        }
        return (E)this.loadEntity((b, e, tx) -> e);
    }

    protected <T> T loadEntity(EntityConvertor<BE, E, T> conversion) throws EntityNotFoundException, RelationNotFoundException {
        return (T)this.inTx(tx -> {
            AbstractElement entity;
            Object result = tx.querySingle(this.context.select().get());
            if (result == null) {
                this.throwNotFoundException();
            }
            if (!this.isApplicable(entity = (AbstractElement)tx.convert(result, this.context.entityClass))) {
                this.throwNotFoundException();
            }
            return conversion.convert(result, entity, tx);
        });
    }

    @Override
    public void delete() {
        this.inTx(tx -> {
            Util.delete(this.context.entityClass, tx, this.context.select().get(), this::preDelete, this::postDelete);
            return null;
        });
        this.useCachedEntity = false;
        this.context.setCreatedEntity(null);
    }

    @Override
    public void update(U u) throws EntityNotFoundException, RelationNotFoundException {
        this.inTx(tx -> {
            Util.update(this.context.entityClass, tx, this.context.select().get(), u, this::preUpdate, this::postUpdate);
            return null;
        });
        if (this.useCachedEntity && this.context.getCreatedEntity() != null) {
            this.context.setCreatedEntity(((AbstractElement)this.context.getCreatedEntity()).update().with(u));
        }
    }

    protected void preDelete(BE deletedEntity, Transaction<BE> transaction) {
    }

    protected void postDelete(BE deletedEntity, Transaction<BE> transaction) {
    }

    protected void preUpdate(BE updatedEntity, U update, Transaction<BE> transaction) {
    }

    protected void postUpdate(BE updatedEntity, Transaction<BE> transaction) {
    }

    @Override
    public Page<E> entities(Pager pager) {
        return this.loadEntities(pager, (b, e, tx) -> e);
    }

    protected <T> Page<T> loadEntities(Pager pager, EntityConvertor<BE, E, T> conversionFunction) {
        return this.inCommittableTx(tx -> {
            Function<Object, Pair> conversion = e -> new Pair(e, tx.convert(e, this.context.entityClass));
            Function<Pair, Boolean> filter = this.context.configuration.getResultFilter() == null ? null : p -> this.context.configuration.getResultFilter().isApplicable((AbstractElement)((Pair)p).second);
            Page<Pair> intermediate = tx.query(this.context.select().get(), pager, conversion, filter);
            return new TransformingPage<Pair<BE, E>, T>(intermediate, p -> conversionFunction.convert(((Pair)p).first, (AbstractElement)((Pair)p).second, tx)){

                @Override
                public void close() {
                    try {
                        tx.commit();
                    }
                    catch (CommitFailureException e) {
                        throw new IllegalStateException("Failed to commit the read operation.", e);
                    }
                    super.close();
                }
            };
        });
    }

    protected void throwNotFoundException() {
        Fetcher.throwNotFoundException(this.context);
    }

    static void throwNotFoundException(TraversalContext<?, ?> context) {
        if (Entity.class.isAssignableFrom(context.entityClass)) {
            throw new EntityNotFoundException(context.entityClass, Query.filters(context.select().get()));
        }
        throw new RelationNotFoundException((String)null, Query.filters(context.sourcePath));
    }

    static interface EntityConvertor<BE, E extends AbstractElement<?, ?>, T> {
        public T convert(BE var1, E var2, Transaction<BE> var3);
    }

    private static final class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }
    }
}

