/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.codahale.metrics.Timer;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.DiscoveryEvent;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryStorage;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Instance;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.SyncConfiguration;
import org.hawkular.inventory.api.model.SyncRequest;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.SegmentType;

public class AsyncInventoryStorage
implements InventoryStorage {
    private static final MsgLogger log = AgentLoggers.getLogger(AsyncInventoryStorage.class);
    private final String feedId;
    private final MonitorServiceConfiguration.StorageAdapterConfiguration config;
    private final HttpClientBuilder httpClientBuilder;
    private final Diagnostics diagnostics;

    public AsyncInventoryStorage(String feedId, MonitorServiceConfiguration.StorageAdapterConfiguration config, HttpClientBuilder httpClientBuilder, Diagnostics diagnostics) {
        this.feedId = feedId;
        this.config = config;
        this.httpClientBuilder = httpClientBuilder;
        this.diagnostics = diagnostics;
    }

    public void shutdown() {
        log.debugf("Shutting down async inventory storage", new Object[0]);
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> void resourcesRemoved(InventoryEvent<L> event) {
        List<Resource<L>> removedResources = event.getPayload();
        for (Resource<L> removedResource : removedResources) {
            if (removedResource.getParent() != null) continue;
            try {
                log.debugf("Removing root resource: %s", removedResource);
                MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint = event.getSamplingService().getMonitoredEndpoint();
                String endpointTenantId = endpoint.getEndpointConfiguration().getTenantId();
                String tenantIdToUse = endpointTenantId != null ? endpointTenantId : this.config.getTenantId();
                CanonicalPath resourceCanonicalPath = (CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantIdToUse)).feed(this.feedId)).resource(removedResource.getID().getIDString())).get();
                StringBuilder deleteUrl = Util.getContextUrlString(this.config.getUrl(), this.config.getInventoryContext());
                deleteUrl.append("entity").append(resourceCanonicalPath.toString());
                Request request = this.httpClientBuilder.buildJsonDeleteRequest(deleteUrl.toString(), this.getTenantHeader(tenantIdToUse));
                long start = System.currentTimeMillis();
                Response response = this.httpClientBuilder.getHttpClient().newCall(request).execute();
                try {
                    long duration = System.currentTimeMillis() - start;
                    if (response.code() != 204 && response.code() != 404) {
                        throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                    }
                    log.debugf("Took [%d]ms to remove root resource [%s]", duration, removedResource);
                }
                finally {
                    response.body().close();
                }
            }
            catch (InterruptedException ie) {
                log.errorFailedToStoreInventoryData(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.errorFailedToStoreInventoryData(e);
                this.diagnostics.getStorageErrorRate().mark(1L);
            }
        }
    }

    @Override
    public <L> void discoveryCompleted(DiscoveryEvent<L> event) {
        MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint = event.getSamplingService().getMonitoredEndpoint();
        String endpointTenantId = endpoint.getEndpointConfiguration().getTenantId();
        String tenantIdToUse = endpointTenantId != null ? endpointTenantId : this.config.getTenantId();
        SyncPayloadBuilder<L> bldr = new SyncPayloadBuilder<L>(tenantIdToUse, this.feedId);
        Map blueprints = bldr.build(event.getResourceManager());
        blueprints.forEach((r, bp) -> this.performResourceSync((InventoryStructure<Resource.Blueprint>)bp, tenantIdToUse, event.getResourceManager().size(r)));
    }

    @Override
    public <L> void allResourceTypes(Map<String, List<ResourceType<L>>> typesByTenantId) {
        for (Map.Entry<String, List<ResourceType<L>>> entry : typesByTenantId.entrySet()) {
            String tenantIdToUse = entry.getKey() != null ? entry.getKey() : this.config.getTenantId();
            List<ResourceType<L>> types = entry.getValue();
            SyncPayloadBuilder<L> bldr = new SyncPayloadBuilder<L>(tenantIdToUse, this.feedId);
            InventoryStructure<Feed.Blueprint> payload = bldr.build(types);
            this.performResourceTypeSync(payload, tenantIdToUse, types.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <L> void performResourceSync(InventoryStructure<Resource.Blueprint> resourceStructure, String tenantIdToUse, int totalResourceCount) {
        if (resourceStructure.getRoot() != null) {
            try {
                SyncConfiguration syncConfig = SyncConfiguration.builder().withAllTypes().build();
                SyncRequest sync = new SyncRequest(syncConfig, resourceStructure);
                StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getInventoryContext());
                url.append("sync");
                url.append("/f;").append(this.feedId);
                url.append("/r;").append(Util.urlEncodeQuery(((Resource.Blueprint)resourceStructure.getRoot()).getId()));
                String jsonPayload = Util.toJson(sync);
                Map<String, String> headers = this.getTenantHeader(tenantIdToUse);
                log.tracef("Syncing [%d] resources to inventory: headers=[%s] body=[%s]", totalResourceCount, headers, jsonPayload);
                Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), headers, jsonPayload);
                Call call = this.httpClientBuilder.getHttpClient().newCall(request);
                Timer.Context timer = this.diagnostics.getInventoryStorageRequestTimer().time();
                Response response = call.execute();
                try {
                    long durationNanos = timer.stop();
                    log.tracef("Received sync response from inventory: code [%d]", response.code());
                    if (response.code() != 204) {
                        throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                    }
                    this.diagnostics.getInventoryRate().mark((long)totalResourceCount);
                    if (log.isDebugEnabled()) {
                        log.debugf("Took [%d]ms to sync [%d] resources to inventory", TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS), totalResourceCount);
                    }
                }
                finally {
                    response.body().close();
                }
            }
            catch (InterruptedException ie) {
                log.errorFailedToStoreInventoryData(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.errorFailedToStoreInventoryData(e);
                this.diagnostics.getStorageErrorRate().mark(1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <L> void performResourceTypeSync(InventoryStructure<Feed.Blueprint> typeStructure, String tenantIdToUse, int totalResourceTypeCount) {
        if (typeStructure.getRoot() != null) {
            try {
                SyncConfiguration syncConfig = SyncConfiguration.builder().withType(SegmentType.rt).withType(SegmentType.mt).withType(SegmentType.ot).withType(SegmentType.sd).withType(SegmentType.d).build();
                SyncRequest sync = new SyncRequest(syncConfig, typeStructure);
                StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getInventoryContext());
                url.append("sync");
                url.append("/f;").append(this.feedId);
                String jsonPayload = Util.toJson(sync);
                Map<String, String> headers = this.getTenantHeader(tenantIdToUse);
                log.tracef("Syncing [%d] resource types to inventory: headers=[%s] body=[%s]", totalResourceTypeCount, headers, jsonPayload);
                Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), headers, jsonPayload);
                Call call = this.httpClientBuilder.getHttpClient().newCall(request);
                Timer.Context timer = this.diagnostics.getInventoryStorageRequestTimer().time();
                Response response = call.execute();
                try {
                    long durationNanos = timer.stop();
                    log.tracef("Received type sync response from inventory: code [%d]", response.code());
                    if (response.code() != 204) {
                        throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                    }
                    this.diagnostics.getInventoryRate().mark((long)totalResourceTypeCount);
                    if (log.isDebugEnabled()) {
                        log.debugf("Took [%d]ms to sync [%d] resource types to inventory", TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS), totalResourceTypeCount);
                    }
                }
                finally {
                    response.body().close();
                }
            }
            catch (InterruptedException ie) {
                log.errorFailedToStoreInventoryData(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.errorFailedToStoreInventoryData(e);
                this.diagnostics.getStorageErrorRate().mark(1L);
            }
        }
    }

    private Map<String, String> getTenantHeader(String tenantId) {
        if (tenantId == null) {
            throw new IllegalArgumentException("tenantId must not be null");
        }
        return Collections.singletonMap("Hawkular-Tenant", tenantId);
    }

    private static class SyncPayloadBuilder<L> {
        private final String feedId;
        private final String tenantId;
        private final Map<IdType, Set<String>> addedIds;

        public SyncPayloadBuilder(String tenantId, String feedId) {
            this.tenantId = tenantId;
            this.feedId = feedId;
            this.addedIds = new HashMap<IdType, Set<String>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<Resource<L>, InventoryStructure.Offline<Resource.Blueprint>> build(ResourceManager<L> resourceManager) {
            Set<Resource<L>> roots = resourceManager.getRootResources();
            HashMap<Resource<L>, InventoryStructure.Offline<Resource.Blueprint>> retVal = new HashMap<Resource<L>, InventoryStructure.Offline<Resource.Blueprint>>(roots.size());
            Map<IdType, Set<String>> map = this.addedIds;
            synchronized (map) {
                for (Resource<L> root : roots) {
                    this.prepareAddedIds();
                    Resource.Blueprint rootBP = this.buildResourceBlueprint(root);
                    InventoryStructure.Builder inventoryBuilder = InventoryStructure.Offline.of((Entity.Blueprint)rootBP);
                    this.resource(resourceManager, root, (InventoryStructure.AbstractBuilder<?>)inventoryBuilder);
                    retVal.put(root, (InventoryStructure.Offline<Resource.Blueprint>)inventoryBuilder.build());
                }
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InventoryStructure<Feed.Blueprint> build(List<ResourceType<L>> resourceTypes) {
            InventoryStructure.Builder inventoryBuilder = InventoryStructure.Offline.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId(this.feedId)).build());
            Map<IdType, Set<String>> map = this.addedIds;
            synchronized (map) {
                this.prepareAddedIds();
                for (ResourceType<L> resourceType : resourceTypes) {
                    this.resourceType(resourceType, inventoryBuilder);
                }
            }
            return inventoryBuilder.build();
        }

        private void prepareAddedIds() {
            this.addedIds.clear();
            this.addedIds.put(IdType.RESOURCE_TYPE, new HashSet());
            this.addedIds.put(IdType.METRIC_TYPE, new HashSet());
        }

        private Resource.Blueprint buildResourceBlueprint(Resource<L> resource) {
            String resourceId = this.getInventoryId(resource);
            String resourceName = resource.getName().getNameString();
            String resourceTypePath = ((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)this.newPathPrefix().resourceType(this.getInventoryId(resource.getResourceType()))).get()).toString();
            Map<String, Object> resourceProperties = resource.getProperties();
            Resource.Blueprint resourceBP = ((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId(resourceId)).withName(resourceName)).withResourceTypePath(resourceTypePath).withProperties(resourceProperties)).build();
            return resourceBP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resource(ResourceManager<L> resourceManager, Resource<L> resource, InventoryStructure.AbstractBuilder<?> resourceBuilder) {
            Collection<ResourceConfigurationPropertyInstance<L>> resConfigInstances = resource.getResourceConfigurationProperties();
            this.resourceConfigurations(resConfigInstances, resourceBuilder);
            Collection<MeasurementInstance<L, MetricType<L>>> metricInstances = resource.getMetrics();
            for (Instance instance : metricInstances) {
                this.metric(instance, resourceBuilder);
            }
            Collection<MeasurementInstance<L, AvailType<L>>> availInstances = resource.getAvails();
            for (Instance instance : availInstances) {
                this.metric(instance, resourceBuilder);
            }
            Set<Resource<L>> set = resourceManager.getChildren(resource);
            for (Resource<L> child : set) {
                Resource.Blueprint childBP = this.buildResourceBlueprint(child);
                InventoryStructure.ChildBuilder childBuilder = resourceBuilder.startChild((Entity.Blueprint)childBP);
                try {
                    this.resource(resourceManager, child, (InventoryStructure.AbstractBuilder<?>)childBuilder);
                }
                finally {
                    childBuilder.end();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resourceType(ResourceType<L> resourceType, InventoryStructure.Builder<?> inventoryBuilder) {
            String resourceTypeId = this.getInventoryId(resourceType);
            if (!this.addedIds.get((Object)IdType.RESOURCE_TYPE).add(resourceTypeId)) {
                return;
            }
            String resourceTypeName = resourceType.getName().getNameString();
            Map<String, Object> resourceTypeProperties = resourceType.getProperties();
            ResourceType.Blueprint resourceTypeBP = ((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId(resourceTypeId)).withName(resourceTypeName)).withProperties(resourceTypeProperties)).build();
            InventoryStructure.ChildBuilder childBuilder = inventoryBuilder.startChild((Entity.Blueprint)resourceTypeBP);
            try {
                Collection<Operation<L>> ops = resourceType.getOperations();
                for (Operation<L> operation : ops) {
                    this.operation(operation, childBuilder);
                }
                Collection<ResourceConfigurationPropertyType<L>> rcpts = resourceType.getResourceConfigurationPropertyTypes();
                this.resourceConfigurationTypes((Collection<? extends ResourceConfigurationPropertyType<L>>)rcpts, (InventoryStructure.AbstractBuilder<?>)childBuilder);
            }
            finally {
                childBuilder.end();
            }
            Collection<MetricType<L>> metricTypes = resourceType.getMetricTypes();
            for (MetricType metricType : metricTypes) {
                this.metricType(metricType, (InventoryStructure.AbstractBuilder<?>)inventoryBuilder);
            }
            Collection<AvailType<L>> availTypes = resourceType.getAvailTypes();
            for (AvailType<L> availType : availTypes) {
                this.metricType(availType, (InventoryStructure.AbstractBuilder<?>)inventoryBuilder);
            }
        }

        private void metric(Instance<L, ?> metric, InventoryStructure.AbstractBuilder<?> childBuilder) {
            String metricId = this.getInventoryId(metric);
            String metricTypeId = this.getInventoryId((NamedObject)metric.getType());
            String metricTypePath = ((CanonicalPath)((CanonicalPath.MetricTypeBuilder)this.newPathPrefix().metricType(metricTypeId)).get()).toString();
            String metricName = metric.getName().getNameString();
            Map<String, Object> metricProperties = metric.getProperties();
            Metric.Blueprint blueprint = ((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId(metricId)).withMetricTypePath(metricTypePath).withName(metricName)).withProperties(metricProperties)).build();
            childBuilder.addChild((Entity.Blueprint)blueprint);
        }

        private void metricType(MeasurementType<L> metricType, InventoryStructure.AbstractBuilder<?> inventoryBuilder) {
            MetricDataType metricDataType;
            String metricTypeId = this.getInventoryId(metricType);
            if (!this.addedIds.get((Object)IdType.METRIC_TYPE).add(metricTypeId)) {
                return;
            }
            MetricUnit metricUnit = MetricUnit.NONE;
            if (metricType instanceof MetricType) {
                metricUnit = MetricUnit.valueOf((String)((MetricType)metricType).getMetricUnits().name());
                switch (((MetricType)metricType).getMetricType()) {
                    case GAUGE: {
                        metricDataType = MetricDataType.GAUGE;
                        break;
                    }
                    case COUNTER: {
                        metricDataType = MetricDataType.COUNTER;
                        break;
                    }
                    default: {
                        metricDataType = MetricDataType.GAUGE;
                        break;
                    }
                }
            } else if (metricType instanceof AvailType) {
                metricDataType = MetricDataType.AVAILABILITY;
            } else {
                throw new IllegalArgumentException("Invalid measurement type - please report this bug: " + metricType.getClass());
            }
            String metricTypeName = metricType.getName().getNameString();
            long metricTypeIntervalSecs = metricType.getInterval().seconds();
            Map<String, Object> metricTypeProperties = metricType.getProperties();
            MetricType.Blueprint blueprint = ((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)metricDataType).withId(metricTypeId)).withName(metricTypeName)).withInterval(Long.valueOf(metricTypeIntervalSecs)).withProperties(metricTypeProperties)).withUnit(metricUnit).build();
            inventoryBuilder.addChild((Entity.Blueprint)blueprint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void operation(Operation<L> operation, InventoryStructure.ChildBuilder<?> childBuilder) {
            String operationId = this.getInventoryId(operation);
            String operationName = operation.getName().getNameString();
            Map<String, Object> operationProperties = operation.getProperties();
            OperationType.Blueprint blueprint = ((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId(operationId)).withName(operationName)).withProperties(operationProperties)).build();
            List<OperationParam> params = operation.getParameters();
            if (params.isEmpty()) {
                childBuilder.addChild((Entity.Blueprint)blueprint);
            } else {
                InventoryStructure.ChildBuilder opBuilder = childBuilder.startChild((Entity.Blueprint)blueprint);
                try {
                    StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                    for (OperationParam param : params) {
                        StructuredData.InnerMapBuilder innerMap = structDataBuilder.putMap(param.getName());
                        if (param.getType() != null) {
                            innerMap.putString("type", param.getType());
                        }
                        if (param.getDescription() != null) {
                            innerMap.putString("description", param.getDescription());
                        }
                        if (param.getDefaultValue() != null) {
                            innerMap.putString("defaultValue", param.getDefaultValue());
                        }
                        if (param.isRequired() != null) {
                            innerMap.putBool("required", param.isRequired().booleanValue());
                        }
                        innerMap.closeMap();
                    }
                    DataEntity.Blueprint paramsDataEntity = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.parameterTypes).withValue(structDataBuilder.build()).build();
                    opBuilder.addChild((Entity.Blueprint)paramsDataEntity);
                }
                finally {
                    opBuilder.end();
                }
            }
        }

        private void resourceConfigurationTypes(Collection<? extends ResourceConfigurationPropertyType<L>> rcpts, InventoryStructure.AbstractBuilder<?> childBuilder) {
            if (!rcpts.isEmpty()) {
                StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                for (ResourceConfigurationPropertyType<L> rcpt : rcpts) {
                    structDataBuilder.putString(rcpt.getID().getIDString(), rcpt.getName().getNameString());
                }
                DataEntity.Blueprint dataEntity = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(structDataBuilder.build()).build();
                childBuilder.addChild((Entity.Blueprint)dataEntity);
            }
        }

        private void resourceConfigurations(Collection<? extends ResourceConfigurationPropertyInstance<L>> rcpis, InventoryStructure.AbstractBuilder<?> childBuilder) {
            if (!rcpis.isEmpty()) {
                StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                for (ResourceConfigurationPropertyInstance<L> rcpi : rcpis) {
                    structDataBuilder.putString(rcpi.getID().getIDString(), rcpi.getValue());
                }
                DataEntity.Blueprint dataEntity = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(structDataBuilder.build()).build();
                childBuilder.addChild((Entity.Blueprint)dataEntity);
            }
        }

        private String getInventoryId(NamedObject no) {
            String id = no.getID().equals(ID.NULL_ID) ? no.getName().getNameString() : no.getID().getIDString();
            return id;
        }

        private CanonicalPath.FeedBuilder newPathPrefix() {
            return (CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.tenantId)).feed(this.feedId);
        }

        private static enum IdType {
            RESOURCE_TYPE,
            METRIC_TYPE;

        }
    }
}

