/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.cipher;

import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.cipher.Aes128CtsHmacSha1Decoder;
import org.jboss.security.negotiation.cipher.Aes256CtsHmacSha1Decoder;
import org.jboss.security.negotiation.cipher.ArcFourHmacDecoder;
import org.jboss.security.negotiation.cipher.Des3CbcHmacSha1KdDecoder;
import org.jboss.security.negotiation.cipher.DesCbcCrcDecoder;
import org.jboss.security.negotiation.cipher.DesCbcMd5Decoder;

public abstract class Decoder {
    public static Decoder getInstace(int type) throws NegotiationException {
        Decoder decoder = null;
        switch (type) {
            case 1: {
                decoder = new DesCbcCrcDecoder();
                break;
            }
            case 3: {
                decoder = new DesCbcMd5Decoder();
                break;
            }
            case 16: {
                decoder = new Des3CbcHmacSha1KdDecoder();
                break;
            }
            case 17: {
                decoder = new Aes128CtsHmacSha1Decoder();
                break;
            }
            case 18: {
                decoder = new Aes256CtsHmacSha1Decoder();
                break;
            }
            case 23: {
                decoder = new ArcFourHmacDecoder();
                break;
            }
            default: {
                throw new NegotiationException("Type not supported: " + type);
            }
        }
        return decoder;
    }

    public abstract int keySize();

    public abstract int checksumSize();

    public abstract int confounderSize();

    public abstract int blockSize();

    public abstract byte[] decrypt(byte[] var1, byte[] var2, int var3) throws NegotiationException;

    public int startOfChecksum() {
        return this.confounderSize();
    }

    public int dataSize(byte[] data) {
        return data.length - this.startOfData();
    }

    public int startOfData() {
        return this.confounderSize() + this.checksumSize();
    }

    public byte[] decryptedData(byte[] data) {
        int tempSize = this.dataSize(data);
        byte[] result = new byte[tempSize];
        System.arraycopy(data, this.startOfData(), result, 0, tempSize);
        return result;
    }
}

