/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol.prometheus;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.util.BaseHttpClientGenerator;
import org.hawkular.agent.prometheus.PrometheusScraper;

public class HawkularPrometheusScraper
extends PrometheusScraper {
    private static final String BEARER_TOKEN_USER_ID = "_bearer";
    private final MonitorServiceConfiguration.DynamicEndpointConfiguration endpointConfig;
    private final SSLContext sslContext;

    public HawkularPrometheusScraper(MonitorServiceConfiguration.DynamicEndpointConfiguration endpointConfig, SSLContext sslContext) throws MalformedURLException {
        super(endpointConfig.getConnectionData().getUri().toURL());
        this.endpointConfig = endpointConfig;
        this.sslContext = sslContext;
    }

    protected PrometheusScraper.OpenConnectionDetails openConnection(URL endpointUrl) throws IOException {
        BaseHttpClientGenerator.Configuration.Builder bldr = new BaseHttpClientGenerator.Configuration.Builder().useSsl(endpointUrl.getProtocol().equals("https")).sslContext(this.sslContext).username(this.endpointConfig.getConnectionData().getUsername()).password(this.endpointConfig.getConnectionData().getPassword());
        BaseHttpClientGenerator httpClientGen = new BaseHttpClientGenerator(bldr.build());
        OkHttpClient httpClient = httpClientGen.getHttpClient();
        Request request = this.buildGetRequest(endpointUrl, httpClientGen);
        Call call = httpClient.newCall(request);
        Response response = call.execute();
        ResponseBody responseBody = response.body();
        InputStream inputStream = responseBody.byteStream();
        MediaType contentType = responseBody.contentType();
        return new PrometheusScraper.OpenConnectionDetails((PrometheusScraper)this, inputStream, contentType != null ? contentType.toString() : null);
    }

    private Request buildGetRequest(URL endpointUrl, BaseHttpClientGenerator httpClientGen) {
        Request.Builder requestBuilder = new Request.Builder().get().url(endpointUrl).addHeader("Accept", this.getBinaryFormatContentType());
        if (httpClientGen.getConfiguration().getUsername() != null) {
            if (httpClientGen.getConfiguration().getUsername().equals(BEARER_TOKEN_USER_ID)) {
                requestBuilder.addHeader("Authorization", "Basic " + httpClientGen.buildBase64Credentials());
            } else {
                requestBuilder.addHeader("Authorization", "Bearer " + httpClientGen.getConfiguration().getPassword());
            }
        }
        return requestBuilder.get().build();
    }
}

