/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol.prometheus;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.api.MetricStorage;
import org.hawkular.agent.monitor.api.MetricTagPayloadBuilder;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicEndpointService;
import org.hawkular.agent.monitor.dynamicprotocol.MetricMetadata;
import org.hawkular.agent.monitor.dynamicprotocol.prometheus.HawkularPrometheusScraper;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;
import org.hawkular.metrics.client.common.MetricType;

public class PrometheusDynamicEndpointService
extends DynamicEndpointService {
    private static final MsgLogger log = AgentLoggers.getLogger(PrometheusDynamicEndpointService.class);
    private final Map<String, MetricMetadata> metricExactNames;
    private final Map<Pattern, MetricMetadata> metricRegexNames;
    private final String tenantId;

    public PrometheusDynamicEndpointService(String feedId, MonitoredEndpoint<MonitorServiceConfiguration.DynamicEndpointConfiguration> endpoint, HawkularWildFlyAgentContext hawkularStorage, Collection<MetricMetadata> metrics) {
        super(feedId, endpoint, hawkularStorage, metrics);
        this.tenantId = endpoint.getEndpointConfiguration().getTenantId();
        if (metrics.isEmpty()) {
            this.metricExactNames = null;
            this.metricRegexNames = null;
        } else {
            this.metricExactNames = new HashMap<String, MetricMetadata>();
            this.metricRegexNames = new HashMap<Pattern, MetricMetadata>();
            for (MetricMetadata metric : metrics) {
                String nameString = metric.getName().getNameString();
                if (nameString.matches("[a-zA-Z_:][a-zA-Z0-9_:]*")) {
                    this.metricExactNames.put(nameString, metric);
                    continue;
                }
                this.metricRegexNames.put(Pattern.compile(nameString), metric);
            }
        }
    }

    @Override
    public void run() {
        HawkularPrometheusScraper scraper;
        MonitorServiceConfiguration.DynamicEndpointConfiguration endpointConfig = this.getMonitoredEndpoint().getEndpointConfiguration();
        log.tracef("Prometheus job starting: %s", endpointConfig);
        try {
            scraper = new HawkularPrometheusScraper(endpointConfig, this.getMonitoredEndpoint().getSSLContext());
        }
        catch (MalformedURLException e) {
            log.errorf(e, "Error with Prometheus endpoint [%s], stopping this endpoint service", endpointConfig);
            throw new RuntimeException(e);
        }
        try {
            scraper.scrape(new Walker());
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to scrape data from Prometheus endpoint [%s]", endpointConfig);
        }
    }

    class Walker
    implements PrometheusMetricsWalker {
        private MetricStorage metricStorage;
        private MetricDataPayloadBuilder dataPayloadBuilder;
        private MetricTagPayloadBuilder tagPayloadBuilder;

        public void walkStart() {
            HawkularWildFlyAgentContext storage = PrometheusDynamicEndpointService.this.getHawkularStorage();
            this.metricStorage = storage.getMetricStorage();
            this.dataPayloadBuilder = this.metricStorage.createMetricDataPayloadBuilder();
            this.dataPayloadBuilder.setTenantId(PrometheusDynamicEndpointService.this.tenantId);
            this.tagPayloadBuilder = this.metricStorage.createMetricTagPayloadBuilder();
            this.tagPayloadBuilder.setTenantId(PrometheusDynamicEndpointService.this.tenantId);
        }

        public void walkFinish(int familiesProcessed, int metricsProcessed) {
            log.debugf("Storing [%d] of [%d] Prometheus metrics from endpoint [%s]", this.dataPayloadBuilder.getNumberDataPoints(), metricsProcessed, PrometheusDynamicEndpointService.this.getMonitoredEndpoint());
            this.metricStorage.store(this.dataPayloadBuilder, 0L);
            this.metricStorage.store(this.tagPayloadBuilder, 0L);
        }

        public void walkMetricFamily(MetricFamily family, int index) {
            if (this.metricToBeCollected(family.getName()) == null) {
                return;
            }
            log.debugf("Processing Prometheus Metric Family [%d]: [%s] (%s) (%d total metrics)", new Object[]{index + 1, family.getName(), family.getType(), family.getMetrics().size()});
        }

        public void walkCounterMetric(MetricFamily family, Counter metric, int index) {
            MetricMetadata metricMetadata = this.metricToBeCollected(metric.getName());
            if (metricMetadata == null) {
                return;
            }
            log.debugf("Processing Prometheus Counter Metric [%s|%s]: value=%f", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getValue());
            String key = this.generateKey(family, (Metric)metric, metricMetadata);
            log.debugf("Will store counter in Hawkular Metrics with key: %s", key);
            this.dataPayloadBuilder.addDataPoint(key, System.currentTimeMillis(), metric.getValue(), MetricType.COUNTER);
            Map<String, String> tags = this.generateTags(family, (Metric)metric, metricMetadata);
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                this.tagPayloadBuilder.addTag(key, entry.getKey(), entry.getValue(), MetricType.COUNTER);
            }
        }

        public void walkGaugeMetric(MetricFamily family, Gauge metric, int index) {
            MetricMetadata metricMetadata = this.metricToBeCollected(metric.getName());
            if (metricMetadata == null) {
                return;
            }
            log.debugf("Processing Prometheus Gauge Metric [%s|%s]: value=%f", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getValue());
            String key = this.generateKey(family, (Metric)metric, metricMetadata);
            log.debugf("Will store gauge in Hawkular Metrics with key: %s", key);
            this.dataPayloadBuilder.addDataPoint(key, System.currentTimeMillis(), metric.getValue(), MetricType.GAUGE);
            Map<String, String> tags = this.generateTags(family, (Metric)metric, metricMetadata);
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                this.tagPayloadBuilder.addTag(key, entry.getKey(), entry.getValue(), MetricType.GAUGE);
            }
        }

        public void walkSummaryMetric(MetricFamily family, Summary metric, int index) {
            if (this.metricToBeCollected(metric.getName()) == null) {
                return;
            }
            log.debugf("Prometheus SUMMARY metrics not yet supported - skipping [%s|%s|%s]", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getQuantiles());
        }

        public void walkHistogramMetric(MetricFamily family, Histogram metric, int index) {
            if (this.metricToBeCollected(metric.getName()) == null) {
                return;
            }
            log.debugf("Prometheus HISTOGRAM metrics not yet supported - skipping [%s|%s|%s]", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getBuckets());
        }

        private MetricMetadata metricToBeCollected(String metricName) {
            if (PrometheusDynamicEndpointService.this.metricExactNames == null) {
                return new MetricMetadata(new Name(metricName), null, null);
            }
            MetricMetadata exactMatchMetric = (MetricMetadata)PrometheusDynamicEndpointService.this.metricExactNames.get(metricName);
            if (exactMatchMetric != null) {
                return exactMatchMetric;
            }
            for (Map.Entry entry : PrometheusDynamicEndpointService.this.metricRegexNames.entrySet()) {
                Pattern pattern = (Pattern)entry.getKey();
                if (!pattern.matcher(metricName).matches()) continue;
                return (MetricMetadata)entry.getValue();
            }
            return null;
        }

        private String generateKey(MetricFamily family, Metric metric, MetricMetadata metricMetadata) {
            StringBuilder key = new StringBuilder();
            MonitorServiceConfiguration.DynamicEndpointConfiguration config = PrometheusDynamicEndpointService.this.getMonitoredEndpoint().getEndpointConfiguration();
            String metricIdTemplate = metricMetadata.getMetricIdTemplate();
            if (metricIdTemplate == null || metricIdTemplate.isEmpty()) {
                metricIdTemplate = config.getMetricIdTemplate();
            }
            if (metricIdTemplate == null || metricIdTemplate.isEmpty()) {
                key.append(PrometheusDynamicEndpointService.this.getFeedId()).append("_").append(config.getName()).append("_").append(metric.getName());
            } else {
                key.append(this.replaceTokens(family, metric, config, metricIdTemplate));
            }
            return key.toString();
        }

        private Map<String, String> generateTags(MetricFamily family, Metric metric, MetricMetadata metricMetadata) {
            MonitorServiceConfiguration.DynamicEndpointConfiguration config = PrometheusDynamicEndpointService.this.getMonitoredEndpoint().getEndpointConfiguration();
            HashMap<String, String> tokenizedTags = new HashMap<String, String>();
            if (config.getMetricTags() != null) {
                tokenizedTags.putAll(config.getMetricTags());
            }
            if (metricMetadata.getMetricTags() != null) {
                tokenizedTags.putAll(metricMetadata.getMetricTags());
            }
            HashMap<String, String> generatedTags = new HashMap<String, String>();
            if (!tokenizedTags.isEmpty()) {
                for (Map.Entry tokenizedTag : tokenizedTags.entrySet()) {
                    String name = this.replaceTokens(family, metric, config, (String)tokenizedTag.getKey());
                    String value = this.replaceTokens(family, metric, config, (String)tokenizedTag.getValue());
                    generatedTags.put(name, value);
                }
            }
            generatedTags.putAll(metric.getLabels());
            return generatedTags;
        }

        private String replaceTokens(MetricFamily family, Metric metric, MonitorServiceConfiguration.DynamicEndpointConfiguration config, String string) {
            return string.replaceAll("%FeedId", PrometheusDynamicEndpointService.this.getFeedId()).replaceAll("%ManagedServerName", config.getName()).replaceAll("%MetricTypeName", family.getType().name()).replaceAll("%MetricName", metric.getName());
        }
    }
}

