/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.Arrays;
import java.util.Collection;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicEndpointService;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicProtocolService;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicProtocolServices;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceWriteAttributeHandler;
import org.hawkular.agent.monitor.extension.RemotePrometheusAdd;
import org.hawkular.agent.monitor.extension.RemotePrometheusAttributes;
import org.hawkular.agent.monitor.extension.RemotePrometheusRemove;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public class RemotePrometheusDefinition
extends PersistentResourceDefinition {
    public static final RemotePrometheusDefinition INSTANCE = new RemotePrometheusDefinition();
    static final String REMOTE_PROMETHEUS = "remote-prometheus";

    private RemotePrometheusDefinition() {
        super(PathElement.pathElement((String)REMOTE_PROMETHEUS), (ResourceDescriptionResolver)SubsystemExtension.getResourceDescriptionResolver("managed-servers", REMOTE_PROMETHEUS), (OperationStepHandler)RemotePrometheusAdd.INSTANCE, (OperationStepHandler)RemotePrometheusRemove.INSTANCE, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(RemotePrometheusAttributes.ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        Util.registerOnlyRestartAttributes(resourceRegistration, this.getAttributes());
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RemotePrometheusAttributes.ENABLED, null, (OperationStepHandler)new MonitorServiceWriteAttributeHandler<Void>(new AttributeDefinition[0]){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                boolean newBool;
                if (context.isBooting()) {
                    return false;
                }
                boolean currBool = RemotePrometheusAttributes.ENABLED.resolveValue(context, currentValue).asBoolean();
                if (currBool == (newBool = RemotePrometheusAttributes.ENABLED.resolveValue(context, newValue).asBoolean())) {
                    return false;
                }
                MonitorService monitorService = this.getMonitorService(context);
                DynamicProtocolService promService = monitorService.getDynamicProtocolServices().getPrometheusProtocolService();
                String thisEndpointName = context.getCurrentAddressValue();
                if (newBool) {
                    MonitorServiceConfiguration config = Util.getMonitorServiceConfiguration(context);
                    DynamicProtocolServices newServices = monitorService.createDynamicProtocolServicesBuilder().prometheusDynamicProtocolService(config.getPrometheusConfiguration(), monitorService.getHawkularMonitorContext()).build();
                    DynamicEndpointService endpointService = newServices.getPrometheusProtocolService().getDynamicEndpointServices().get(thisEndpointName);
                    promService.add(endpointService);
                } else {
                    promService.remove(thisEndpointName);
                }
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode originalValue, ModelNode newBadValue, Void handback) throws OperationFailedException {
            }
        });
    }
}

