/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NamedObject;

public abstract class NodeLocationProvider<L>
extends NamedObject {
    private final L location;

    public NodeLocationProvider(ID id, Name name, L location) {
        super(id, name);
        if (location == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a null location");
        }
        this.location = location;
    }

    public L getLocation() {
        return this.location;
    }

    public static class Builder<This extends Builder<?, L>, L> {
        protected ID id;
        protected Name name;
        protected L location;

        protected Builder() {
        }

        protected Builder(NodeLocationProvider<L> template) {
            this.id(template.getID());
            this.name(template.getName());
            this.location(template.getLocation());
        }

        public This id(ID id) {
            this.id = id;
            return this.getThis();
        }

        public This name(Name name) {
            this.name = name;
            return this.getThis();
        }

        public This location(L location) {
            this.location = location;
            return this.getThis();
        }

        private This getThis() {
            return (This)this;
        }
    }
}

