/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;

public class PingStorageDispatcher
implements Runnable {
    private static final MsgLogger log = AgentLoggers.getLogger(PingStorageDispatcher.class);
    private final SchedulerConfiguration config;
    private final StorageAdapter storageAdapter;
    private final Diagnostics diagnostics;
    private final String metricId;

    public PingStorageDispatcher(SchedulerConfiguration config, StorageAdapter storageAdapter, Diagnostics diagnostics) {
        this.config = config;
        this.storageAdapter = storageAdapter;
        this.diagnostics = diagnostics;
        this.metricId = "hawkular-feed-availability-" + this.config.getFeedId();
    }

    public SchedulerConfiguration getConfig() {
        return this.config;
    }

    public StorageAdapter getStorageAdapter() {
        return this.storageAdapter;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        Set<AvailDataPoint> pings = this.config.getTenantIds().stream().map(t -> new AvailDataPoint(this.metricId, now, Avail.UP, (String)t)).collect(Collectors.toSet());
        log.tracef("Sending agent availability pings: %s", pings);
        this.storageAdapter.storeAvails(pings, 0L);
    }
}

