/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.annotated.runtime.InvokableAnnotatedMethod;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.CovariantTypes;
import org.jboss.weld.util.Decorators;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.Reflections;

class DecoratedMethods {
    private static final Object NULL_MARKER = new Object();
    private final Set<InvokableAnnotatedMethod<?>> decoratedTypeMethods;
    private final ConcurrentMap<Method, Object> cache;

    DecoratedMethods(BeanManagerImpl manager, WeldDecorator<?> decorator) {
        this.decoratedTypeMethods = Decorators.getDecoratorMethods(manager, decorator);
        this.cache = new ConcurrentHashMap<Method, Object>();
    }

    public InvokableAnnotatedMethod<?> getDecoratedMethod(Method method) {
        Object value;
        if (!this.cache.containsKey(method)) {
            this.cache.putIfAbsent(method, this.findMatchingDecoratedMethod(method));
        }
        if ((value = this.cache.get(method)) == NULL_MARKER) {
            return null;
        }
        return (InvokableAnnotatedMethod)Reflections.cast(value);
    }

    /*
     * WARNING - void declaration
     */
    private Object findMatchingDecoratedMethod(Method method) {
        void var4_6;
        for (InvokableAnnotatedMethod<?> decoratedMethod : this.decoratedTypeMethods) {
            if (!decoratedMethod.getJavaMember().equals(method)) continue;
            return decoratedMethod;
        }
        ArrayList<InvokableAnnotatedMethod> matching = new ArrayList<InvokableAnnotatedMethod>();
        for (InvokableAnnotatedMethod invokableAnnotatedMethod : this.decoratedTypeMethods) {
            if (!this.matches(invokableAnnotatedMethod, method)) continue;
            matching.add(invokableAnnotatedMethod);
        }
        if (matching.isEmpty()) {
            return NULL_MARKER;
        }
        if (matching.size() == 1) {
            return matching.get(0);
        }
        InvokableAnnotatedMethod mostSpecific = (InvokableAnnotatedMethod)matching.get(0);
        boolean bl = true;
        while (var4_6 < matching.size()) {
            InvokableAnnotatedMethod candidate = (InvokableAnnotatedMethod)matching.get((int)var4_6);
            if (this.isMoreSpecific(candidate, mostSpecific)) {
                mostSpecific = candidate;
            }
            ++var4_6;
        }
        return mostSpecific;
    }

    private boolean matches(InvokableAnnotatedMethod<?> decoratedMethod, Method candidate) {
        if (candidate.getParameterTypes().length != decoratedMethod.getParameters().size()) {
            return false;
        }
        if (!candidate.getName().equals(decoratedMethod.getJavaMember().getName())) {
            return false;
        }
        for (int i = 0; i < candidate.getParameterTypes().length; ++i) {
            Type decoratedMethodParamType = decoratedMethod.getJavaMember().getGenericParameterTypes()[i];
            Type candidateParamType = candidate.getGenericParameterTypes()[i];
            if (!(Types.containsUnresolvedTypeVariableOrWildcard(decoratedMethodParamType) || Types.containsUnresolvedTypeVariableOrWildcard(candidateParamType) ? !decoratedMethod.getJavaMember().getParameterTypes()[i].isAssignableFrom(candidate.getParameterTypes()[i]) : !CovariantTypes.isAssignableFrom(decoratedMethodParamType, candidateParamType))) continue;
            return false;
        }
        return true;
    }

    private boolean isMoreSpecific(InvokableAnnotatedMethod<?> candidate, InvokableAnnotatedMethod<?> mostSpecific) {
        for (int i = 0; i < candidate.getJavaMember().getGenericParameterTypes().length; ++i) {
            if (!Types.isMoreSpecific(candidate.getJavaMember().getGenericParameterTypes()[i], mostSpecific.getJavaMember().getGenericParameterTypes()[i])) continue;
            return true;
        }
        return false;
    }
}

