/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class TombstoneUpdate<T> {
    public static TombstoneUpdate EVICT = new TombstoneUpdate<Object>(Long.MIN_VALUE, null);
    private long timestamp;
    private T value;

    public TombstoneUpdate(long timestamp, T value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TombstoneUpdate{");
        sb.append("timestamp=").append(this.timestamp);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public static class Externalizer
    implements AdvancedExternalizer<TombstoneUpdate> {
        public Set<Class<? extends TombstoneUpdate>> getTypeClasses() {
            return Collections.singleton(TombstoneUpdate.class);
        }

        public Integer getId() {
            return 1203;
        }

        public void writeObject(ObjectOutput output, TombstoneUpdate object) throws IOException {
            output.writeObject(object.getValue());
            if (object.getValue() != null) {
                output.writeLong(object.getTimestamp());
            }
        }

        public TombstoneUpdate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            if (value != null) {
                long timestamp = input.readLong();
                return new TombstoneUpdate<Object>(timestamp, value);
            }
            return EVICT;
        }
    }
}

