/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.ExtensionHandler;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.as.server.parsing.StandaloneXml_4;
import org.jboss.as.server.parsing.StandaloneXml_Legacy;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class StandaloneXml
extends CommonXml {
    private final ParsingOption[] parsingOptions;
    private final ExtensionHandler extensionHandler;

    public StandaloneXml(ModuleLoader loader, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        super(new SocketBindingsXml.ServerSocketBindingsXml());
        this.extensionHandler = new DefaultExtensionHandler(loader, executorService, extensionRegistry);
        this.parsingOptions = new ParsingOption[0];
    }

    public StandaloneXml(ExtensionHandler handler, ParsingOption ... options) {
        super(new SocketBindingsXml.ServerSocketBindingsXml());
        this.extensionHandler = handler;
        this.parsingOptions = options;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        Namespace readerNS = Namespace.forUri((String)reader.getNamespaceURI());
        switch (readerNS.getMajorVersion()) {
            case 1: 
            case 2: 
            case 3: {
                new StandaloneXml_Legacy(this.extensionHandler, readerNS, this.parsingOptions).readElement(reader, operationList);
                break;
            }
            default: {
                new StandaloneXml_4(this.extensionHandler, readerNS, this.parsingOptions).readElement(reader, operationList);
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        new StandaloneXml_4(this.extensionHandler, Namespace.CURRENT, this.parsingOptions).writeContent(writer, context);
    }

    class DefaultExtensionHandler
    implements ExtensionHandler {
        private final ExtensionXml extensionXml;
        private final ExtensionRegistry extensionRegistry;

        public DefaultExtensionHandler(ModuleLoader loader, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
            this.extensionXml = new ExtensionXml(loader, executorService, extensionRegistry);
        }

        @Override
        public void parseExtensions(XMLExtendedStreamReader reader, ModelNode address, Namespace namespace, List<ModelNode> list) throws XMLStreamException {
            this.extensionXml.parseExtensions(reader, address, namespace, list);
        }

        @Override
        public Set<ProfileParsingCompletionHandler> getProfileParsingCompletionHandlers() {
            return this.extensionRegistry.getProfileParsingCompletionHandlers();
        }

        @Override
        public void writeExtensions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
            this.extensionXml.writeExtensions(writer, modelNode);
        }
    }

    public static enum ParsingOption {
        IGNORE_SUBSYSTEM_FAILURES;


        public boolean isSet(ParsingOption[] options) {
            boolean matches = false;
            for (ParsingOption option : options) {
                if (!this.equals((Object)option)) continue;
                matches = true;
                break;
            }
            return matches;
        }
    }
}

