/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.VersionTransformer;
import org.apache.cxf.ws.rm.v200502wsa15.AckRequestedType;
import org.apache.cxf.ws.rm.v200502wsa15.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200502wsa15.SequenceFaultType;
import org.apache.cxf.ws.rm.v200502wsa15.SequenceType;
import org.apache.cxf.ws.rm.v200502wsa15.TerminateSequenceType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EncoderDecoder10AImpl
extends EncoderDecoder {
    public static final EncoderDecoder10AImpl INSTANCE = new EncoderDecoder10AImpl();
    private static AtomicReference<JAXBContext> jaxbContextReference = new AtomicReference();
    private static final Logger LOG = LogUtils.getL7dLogger(EncoderDecoder10AImpl.class);

    private EncoderDecoder10AImpl() {
    }

    @Override
    public String getWSRMNamespace() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm";
    }

    @Override
    public String getWSANamespace() {
        return "http://www.w3.org/2005/08/addressing";
    }

    @Override
    public RMConstants getConstants() {
        return RM10Constants.INSTANCE;
    }

    @Override
    public Class<?> getCreateSequenceType() {
        return org.apache.cxf.ws.rm.v200502wsa15.CreateSequenceType.class;
    }

    @Override
    public Class<?> getCreateSequenceResponseType() {
        return org.apache.cxf.ws.rm.v200502wsa15.CreateSequenceResponseType.class;
    }

    @Override
    public Class<?> getTerminateSequenceType() {
        return TerminateSequenceType.class;
    }

    @Override
    public Class<?> getTerminateSequenceResponseType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected JAXBContext getContext() throws JAXBException {
        JAXBContext jaxbContext = jaxbContextReference.get();
        if (jaxbContext != null) return jaxbContext;
        Class<EncoderDecoder10AImpl> clazz = EncoderDecoder10AImpl.class;
        synchronized (EncoderDecoder10AImpl.class) {
            jaxbContext = jaxbContextReference.get();
            if (jaxbContext != null) return jaxbContext;
            Class<?> clas = RMUtils.getWSRM200502WSA200508Factory().getClass();
            jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(clas), (ClassLoader)clas.getClassLoader());
            jaxbContextReference.set(jaxbContext);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return jaxbContext;
        }
    }

    @Override
    protected void buildHeaders(org.apache.cxf.ws.rm.v200702.SequenceType seq, Collection<org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement> acks, Collection<org.apache.cxf.ws.rm.v200702.AckRequestedType> reqs, boolean last, Element header, Marshaller marshaller) throws JAXBException {
        if (null != seq) {
            LOG.log(Level.FINE, "encoding sequence into RM header");
            SequenceType toseq = VersionTransformer.convert200502wsa15(seq);
            if (last) {
                toseq.setLastMessage(new SequenceType.LastMessage());
            }
            JAXBElement<SequenceType> element = RMUtils.getWSRM200502WSA200508Factory().createSequence(toseq);
            marshaller.marshal(element, (Node)header);
        }
        if (null != acks) {
            LOG.log(Level.FINE, "encoding sequence acknowledgement(s) into RM header");
            for (org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement ack : acks) {
                marshaller.marshal((Object)VersionTransformer.convert200502wsa15(ack), (Node)header);
            }
        }
        if (null != reqs) {
            LOG.log(Level.FINE, "encoding acknowledgement request(s) into RM header");
            for (org.apache.cxf.ws.rm.v200702.AckRequestedType req : reqs) {
                marshaller.marshal(RMUtils.getWSRM200502WSA200508Factory().createAckRequested(VersionTransformer.convert200502wsa15(req)), (Node)header);
            }
        }
    }

    @Override
    public void buildHeaderFault(SequenceFault sf, Element header, Marshaller marshaller) throws JAXBException {
        SequenceFaultType flt = new SequenceFaultType();
        flt.setFaultCode(sf.getFaultCode());
        Object detail = sf.getDetail();
        Document doc = DOMUtils.createDocument();
        if (detail instanceof Element) {
            flt.getAny().add(detail);
        } else if (detail instanceof Identifier) {
            marshaller.marshal((Object)VersionTransformer.convert200502wsa15((Identifier)detail), (Node)doc);
        } else if (detail instanceof org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement) {
            marshaller.marshal((Object)VersionTransformer.convert200502wsa15((org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement)detail), (Node)doc);
        }
        Element data = doc.getDocumentElement();
        if (data != null) {
            flt.getAny().add(data);
        }
        if ((data = sf.getExtraDetail()) != null) {
            flt.getAny().add(data);
        }
        marshaller.marshal((Object)new JAXBElement(RM10Constants.SEQUENCE_FAULT_QNAME, SequenceFaultType.class, (Object)flt), (Node)header);
    }

    @Override
    public Element encodeSequenceAcknowledgement(org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement ack) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.marshal((Object)VersionTransformer.convert200502wsa15(ack), (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public Element encodeIdentifier(Identifier id) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.marshal((Object)VersionTransformer.convert200502wsa15(id), (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public org.apache.cxf.ws.rm.v200702.SequenceType decodeSequenceType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, SequenceType.class);
        return VersionTransformer.convert((SequenceType)jaxbElement.getValue());
    }

    @Override
    public CloseSequenceType decodeSequenceTypeCloseSequence(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, SequenceType.class);
        SequenceType seq = (SequenceType)jaxbElement.getValue();
        if (seq.isSetLastMessage()) {
            CloseSequenceType close = new CloseSequenceType();
            close.setIdentifier(VersionTransformer.convert(seq.getIdentifier()));
            close.setLastMsgNumber(seq.getMessageNumber());
            return close;
        }
        return null;
    }

    @Override
    public org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement decodeSequenceAcknowledgement(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        SequenceAcknowledgement ack = (SequenceAcknowledgement)unmarshaller.unmarshal((Node)elem);
        return VersionTransformer.convert(ack);
    }

    @Override
    public org.apache.cxf.ws.rm.v200702.AckRequestedType decodeAckRequestedType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, AckRequestedType.class);
        return VersionTransformer.convert((AckRequestedType)jaxbElement.getValue());
    }

    @Override
    public Object convertToSend(CreateSequenceType create) {
        return VersionTransformer.convert200502wsa15(create);
    }

    @Override
    public Object convertToSend(org.apache.cxf.ws.rm.v200702.TerminateSequenceType term) {
        return VersionTransformer.convert200502wsa15(term);
    }

    @Override
    public Object convertToSend(CreateSequenceResponseType create) {
        return VersionTransformer.convert200502wsa15(create);
    }

    @Override
    public CreateSequenceType convertReceivedCreateSequence(Object create) {
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502wsa15.CreateSequenceType)create);
    }

    @Override
    public CreateSequenceResponseType convertReceivedCreateSequenceResponse(Object response) {
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502wsa15.CreateSequenceResponseType)response);
    }

    @Override
    public org.apache.cxf.ws.rm.v200702.TerminateSequenceType convertReceivedTerminateSequence(Object term) {
        return VersionTransformer.convert((TerminateSequenceType)term);
    }
}

