/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonValue;
import oshi.hardware.CentralProcessor;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.UsbDevice;
import oshi.json.NullAwareJsonObjectBuilder;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;

public abstract class AbstractHardwareAbstractionLayer
implements HardwareAbstractionLayer {
    private static final long serialVersionUID = 1L;
    protected CentralProcessor processor;
    protected GlobalMemory memory;
    protected Sensors sensors;
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    @Override
    public abstract GlobalMemory getMemory();

    @Override
    public abstract CentralProcessor getProcessor();

    @Override
    public abstract PowerSource[] getPowerSources();

    @Override
    public abstract FileSystem getFileSystem();

    @Override
    public abstract OSFileStore[] getFileStores();

    @Override
    public abstract HWDiskStore[] getDiskStores();

    @Override
    public abstract Display[] getDisplays();

    @Override
    public abstract Sensors getSensors();

    @Override
    public abstract UsbDevice[] getUsbDevices();

    @Override
    public JsonObject toJSON() {
        JsonArrayBuilder powerSourceArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (PowerSource powerSource : this.getPowerSources()) {
            powerSourceArrayBuilder.add((JsonValue)powerSource.toJSON());
        }
        JsonArrayBuilder fileStoreArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (OSFileStore fileStore : this.getFileStores()) {
            fileStoreArrayBuilder.add((JsonValue)fileStore.toJSON());
        }
        JsonArrayBuilder diskStoreArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (HWDiskStore diskStore : this.getDiskStores()) {
            diskStoreArrayBuilder.add((JsonValue)diskStore.toJSON());
        }
        JsonArrayBuilder networkIFArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (NetworkIF netStore : this.getNetworkIFs()) {
            networkIFArrayBuilder.add((JsonValue)netStore.toJSON());
        }
        JsonArrayBuilder displayArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (Display display : this.getDisplays()) {
            displayArrayBuilder.add((JsonValue)display.toJSON());
        }
        JsonArrayBuilder usbDeviceArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (UsbDevice usbDevice : this.getUsbDevices()) {
            usbDeviceArrayBuilder.add((JsonValue)usbDevice.toJSON());
        }
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("processor", (JsonValue)this.getProcessor().toJSON()).add("memory", (JsonValue)this.getMemory().toJSON()).add("powerSources", (JsonValue)powerSourceArrayBuilder.build()).add("fileSystem", (JsonValue)this.getFileSystem().toJSON()).add("fileStores", (JsonValue)fileStoreArrayBuilder.build()).add("disks", (JsonValue)diskStoreArrayBuilder.build()).add("networks", (JsonValue)networkIFArrayBuilder.build()).add("displays", (JsonValue)displayArrayBuilder.build()).add("sensors", (JsonValue)this.getSensors().toJSON()).add("usbDevices", (JsonValue)usbDeviceArrayBuilder.build()).build();
    }
}

