/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus;

import java.net.URL;
import org.hawkular.agent.prometheus.PrometheusScraper;
import org.hawkular.agent.prometheus.walkers.JSONPrometheusMetricsWalker;
import org.hawkular.agent.prometheus.walkers.LoggingPrometheusMetricsWalker;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;
import org.hawkular.agent.prometheus.walkers.SimplePrometheusMetricsWalker;
import org.hawkular.agent.prometheus.walkers.XMLPrometheusMetricsWalker;
import org.jboss.logging.Logger;

public class PrometheusScraperCli {
    public static void main(String[] args) throws Exception {
        PrometheusMetricsWalker walker;
        if (args.length == 0) {
            throw new Exception("Specify the URL of the Prometheus protocol endpoint.");
        }
        PrometheusMetricsWalkerType walkerType = PrometheusMetricsWalkerType.SIMPLE;
        URL url = null;
        for (String arg : args) {
            if (arg.startsWith("--")) {
                if (arg.equalsIgnoreCase("--xml")) {
                    walkerType = PrometheusMetricsWalkerType.XML;
                    continue;
                }
                if (arg.equalsIgnoreCase("--json")) {
                    walkerType = PrometheusMetricsWalkerType.JSON;
                    continue;
                }
                if (arg.equalsIgnoreCase("--simple")) {
                    walkerType = PrometheusMetricsWalkerType.SIMPLE;
                    continue;
                }
                if (arg.equalsIgnoreCase("--log")) {
                    walkerType = PrometheusMetricsWalkerType.LOG;
                    continue;
                }
                throw new Exception("Invalid argument: " + arg);
            }
            url = new URL(arg);
            break;
        }
        if (url == null) {
            throw new Exception("Specify the URL of the Prometheus protocol endpoint.");
        }
        switch (walkerType) {
            case SIMPLE: {
                walker = new SimplePrometheusMetricsWalker(url);
                break;
            }
            case XML: {
                walker = new XMLPrometheusMetricsWalker(url);
                break;
            }
            case JSON: {
                walker = new JSONPrometheusMetricsWalker();
                break;
            }
            case LOG: {
                walker = new LoggingPrometheusMetricsWalker(Logger.Level.INFO);
                break;
            }
            default: {
                throw new Exception("Invalid walker type: " + (Object)((Object)walkerType));
            }
        }
        PrometheusScraper scraper = new PrometheusScraper(url);
        scraper.scrape(walker);
    }

    static enum PrometheusMetricsWalkerType {
        LOG,
        SIMPLE,
        XML,
        JSON;

    }
}

