/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.binary;

import io.prometheus.client.Metrics;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.agent.prometheus.PrometheusMetricsProcessor;
import org.hawkular.agent.prometheus.binary.BinaryPrometheusMetricDataParser;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.MetricType;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;

public class BinaryPrometheusMetricsProcessor
extends PrometheusMetricsProcessor<Metrics.MetricFamily> {
    public BinaryPrometheusMetricsProcessor(InputStream inputStream, PrometheusMetricsWalker theWalker) {
        super(inputStream, theWalker);
    }

    public BinaryPrometheusMetricDataParser createPrometheusMetricDataParser() {
        return new BinaryPrometheusMetricDataParser(this.getInputStream());
    }

    @Override
    protected MetricFamily convert(Metrics.MetricFamily family) {
        MetricType convertedFamilyType = MetricType.valueOf(family.getType().name());
        MetricFamily.Builder convertedFamilyBuilder = new MetricFamily.Builder();
        convertedFamilyBuilder.setName(family.getName());
        convertedFamilyBuilder.setHelp(family.getHelp());
        convertedFamilyBuilder.setType(convertedFamilyType);
        for (Metrics.Metric metric : family.getMetricList()) {
            Metric.Builder convertedMetricBuilder = null;
            switch (convertedFamilyType) {
                case COUNTER: {
                    convertedMetricBuilder = new Counter.Builder().setValue(metric.getCounter().getValue());
                    break;
                }
                case GAUGE: {
                    convertedMetricBuilder = new Gauge.Builder().setValue(metric.getGauge().getValue());
                    break;
                }
                case SUMMARY: {
                    Metrics.Summary summary = metric.getSummary();
                    List pqList = summary.getQuantileList();
                    ArrayList<Summary.Quantile> hqList = new ArrayList<Summary.Quantile>(pqList.size());
                    for (Metrics.Quantile pq : pqList) {
                        Summary.Quantile hq = new Summary.Quantile(pq.getQuantile(), pq.getValue());
                        hqList.add(hq);
                    }
                    convertedMetricBuilder = new Summary.Builder().setSampleCount(metric.getSummary().getSampleCount()).setSampleSum(metric.getSummary().getSampleSum()).addQuantiles(hqList);
                    break;
                }
            }
            convertedMetricBuilder.setName(family.getName());
            for (Metrics.LabelPair labelPair : metric.getLabelList()) {
                convertedMetricBuilder.addLabel(labelPair.getName(), labelPair.getValue());
            }
            convertedFamilyBuilder.addMetric((Metric)convertedMetricBuilder.build());
        }
        return convertedFamilyBuilder.build();
    }
}

