/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class AnalyzerUtils {
    public static final Log log = LoggerFactory.make();

    private AnalyzerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> tokenizedTermValues(Analyzer analyzer, String field, String text) throws IOException {
        ArrayList<String> tokenList = new ArrayList<String>();
        try (TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(text));){
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                String s = new String(term.buffer(), 0, term.length());
                tokenList.add(s);
            }
            stream.end();
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token[] tokensFromAnalysis(Analyzer analyzer, String field, String text) throws IOException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        try (TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(text));){
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                Token token = new Token();
                token.copyBuffer(term.buffer(), 0, term.length());
                tokenList.add(token);
            }
            stream.end();
        }
        return tokenList.toArray(new Token[tokenList.size()]);
    }

    public static void displayTokens(Analyzer analyzer, String field, String text) throws IOException {
        Token[] tokens;
        for (Token token : tokens = AnalyzerUtils.tokensFromAnalysis(analyzer, field, text)) {
            log.debug("[" + AnalyzerUtils.getTermText(token) + "] ");
        }
    }

    public static void displayTokensWithPositions(Analyzer analyzer, String field, String text, PrintStream printTo) throws IOException {
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis(analyzer, field, text);
        int position = 0;
        for (Token token : tokens) {
            int increment = token.getPositionIncrement();
            if (increment > 0) {
                printTo.println();
                printTo.print((position += increment) + ": ");
            }
            log.debug("[" + AnalyzerUtils.getTermText(token) + "] ");
        }
    }

    public static void displayTokensWithFullDetails(Analyzer analyzer, String field, String text) throws IOException {
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis(analyzer, field, text);
        StringBuilder builder = new StringBuilder();
        int position = 0;
        for (Token token : tokens) {
            int increment = token.getPositionIncrement();
            if (increment > 0) {
                builder.append("\n").append(position += increment).append(": ");
            }
            builder.append("[").append(AnalyzerUtils.getTermText(token)).append(":").append(token.startOffset()).append("->").append(token.endOffset()).append(":").append(token.type()).append("] ");
            log.debug(builder.toString());
        }
    }

    public static String getTermText(Token token) {
        return new String(token.buffer(), 0, token.length());
    }
}

