/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryBuilderFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;
import org.wildfly.clustering.spi.GroupServiceName;

public class InfinispanBeanManagerFactoryBuilder<G, I, T>
implements Builder<BeanManagerFactory<G, I, T, TransactionBatch>>,
Value<BeanManagerFactory<G, I, T, TransactionBatch>>,
InfinispanBeanManagerFactoryConfiguration {
    private final String name;
    private final BeanContext context;
    private final BeanManagerFactoryBuilderConfiguration configuration;
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final InjectedValue<MarshallingConfigurationRepository> repository = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduler = new InjectedValue();
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();

    public InfinispanBeanManagerFactoryBuilder(String name, BeanContext context, BeanManagerFactoryBuilderConfiguration configuration) {
        this.name = name;
        this.context = context;
        this.configuration = configuration;
    }

    public ServiceName getServiceName() {
        return this.context.getDeploymentUnitServiceName().append(new String[]{this.context.getBeanName()}).append(new String[]{"bean-manager"});
    }

    public ServiceBuilder<BeanManagerFactory<G, I, T, TransactionBatch>> build(ServiceTarget target) {
        String containerName = this.configuration.getContainerName();
        ServiceName deploymentUnitServiceName = this.context.getDeploymentUnitServiceName();
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(CacheServiceName.CACHE.getServiceName(containerName, InfinispanBeanManagerFactoryBuilderFactory.getCacheName(deploymentUnitServiceName)), Cache.class, this.cache).addDependency(CacheContainerServiceName.AFFINITY.getServiceName(containerName), KeyAffinityServiceFactory.class, this.affinityFactory).addDependency(deploymentUnitServiceName.append(new String[]{"marshalling"}), MarshallingConfigurationRepository.class, this.repository).addDependency(deploymentUnitServiceName.append(new String[]{this.name, "expiration"}), ScheduledExecutorService.class, this.scheduler).addDependency(deploymentUnitServiceName.append(new String[]{this.name, "eviction"}), Executor.class, this.executor).addDependency(GroupServiceName.COMMAND_DISPATCHER.getServiceName(containerName), CommandDispatcherFactory.class, this.dispatcherFactory).addDependency(CacheGroupServiceName.REGISTRY.getServiceName(containerName, "client-mappings"), Registry.class, this.registry).addDependency(CacheGroupServiceName.NODE_FACTORY.getServiceName(containerName, "client-mappings"), NodeFactory.class, this.nodeFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public BeanManagerFactory<G, I, T, TransactionBatch> getValue() {
        return new InfinispanBeanManagerFactory(this);
    }

    @Override
    public BeanContext getBeanContext() {
        return this.context;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.getValue();
    }

    @Override
    public MarshallingConfigurationRepository getMarshallingConfigurationRepository() {
        return (MarshallingConfigurationRepository)this.repository.getValue();
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return (ScheduledExecutorService)this.scheduler.getValue();
    }

    @Override
    public Executor getExecutor() {
        return (Executor)this.executor.getValue();
    }

    @Override
    public BeanPassivationConfiguration getPassivationConfiguration() {
        return this.configuration;
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.nodeFactory.getValue();
    }

    @Override
    public Registry<String, ?> getRegistry() {
        return (Registry)this.registry.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }
}

