/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.replication;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.impl.FileWrapperJournal;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageInSync;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeginMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.replication.ReplicatedLargeMessage;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.cluster.qourum.SharedNothingBackupQuorum;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;

public final class ReplicationEndpoint
implements ChannelHandler,
ActiveMQComponent {
    private static final boolean trace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private final IOCriticalErrorListener criticalErrorListener;
    private final ActiveMQServerImpl server;
    private final boolean wantedFailBack;
    private final SharedNothingBackupActivation activation;
    private final boolean noSync = false;
    private Channel channel;
    private Journal[] journals;
    private final JournalLoadInformation[] journalLoadInformation = new JournalLoadInformation[2];
    private final Map<JournalStorageManager.JournalContent, Map<Long, JournalSyncFile>> filesReservedForSync = new HashMap<JournalStorageManager.JournalContent, Map<Long, JournalSyncFile>>();
    private Map<JournalStorageManager.JournalContent, Journal> journalsHolder = new HashMap<JournalStorageManager.JournalContent, Journal>();
    private StorageManager storageManager;
    private PagingManager pageManager;
    private final ConcurrentMap<SimpleString, ConcurrentMap<Integer, Page>> pageIndex = new ConcurrentHashMap<SimpleString, ConcurrentMap<Integer, Page>>();
    private final ConcurrentMap<Long, ReplicatedLargeMessage> largeMessages = new ConcurrentHashMap<Long, ReplicatedLargeMessage>();
    private boolean deletePages = true;
    private volatile boolean started;
    private SharedNothingBackupQuorum backupQuorum;
    private Executor executor;

    public ReplicationEndpoint(ActiveMQServerImpl server, IOCriticalErrorListener criticalErrorListener, boolean wantedFailBack, SharedNothingBackupActivation activation) {
        this.server = server;
        this.criticalErrorListener = criticalErrorListener;
        this.wantedFailBack = wantedFailBack;
        this.activation = activation;
    }

    public synchronized void registerJournal(byte id, Journal journal) {
        if (this.journals == null || id >= this.journals.length) {
            Journal[] oldJournals = this.journals;
            this.journals = new Journal[id + 1];
            if (oldJournals != null) {
                for (int i = 0; i < oldJournals.length; ++i) {
                    this.journals[i] = oldJournals[i];
                }
            }
        }
        this.journals[id] = journal;
    }

    public void handlePacket(Packet packet) {
        ReplicationResponseMessage response = new ReplicationResponseMessage();
        byte type = packet.getType();
        try {
            if (!this.started) {
                return;
            }
            if (type == 91) {
                this.handleAppendAddRecord((ReplicationAddMessage)packet);
            } else if (type == 92) {
                this.handleAppendAddTXRecord((ReplicationAddTXMessage)packet);
            } else if (type == 93) {
                this.handleAppendDelete((ReplicationDeleteMessage)packet);
            } else if (type == 94) {
                this.handleAppendDeleteTX((ReplicationDeleteTXMessage)packet);
            } else if (type == 95) {
                this.handlePrepare((ReplicationPrepareMessage)packet);
            } else if (type == 96) {
                this.handleCommitRollback((ReplicationCommitMessage)packet);
            } else if (type == 97) {
                this.handlePageWrite((ReplicationPageWriteMessage)packet);
            } else if (type == 98) {
                this.handlePageEvent((ReplicationPageEventMessage)packet);
            } else if (type == 99) {
                this.handleLargeMessageBegin((ReplicationLargeMessageBeginMessage)packet);
            } else if (type == 101) {
                this.handleLargeMessageWrite((ReplicationLargeMessageWriteMessage)packet);
            } else if (type == 100) {
                this.handleLargeMessageEnd((ReplicationLargeMessageEndMessage)packet);
            } else if (type == 120) {
                response = this.handleStartReplicationSynchronization((ReplicationStartSyncMessage)packet);
            } else if (type == 103) {
                this.handleReplicationSynchronization((ReplicationSyncFileMessage)packet);
            } else if (type == 121) {
                this.handleLiveStopping((ReplicationLiveIsStoppingMessage)packet);
            } else if (type == 116) {
                this.handleFatalError((BackupReplicationStartFailedMessage)packet);
            } else {
                ActiveMQServerLogger.LOGGER.invalidPacketForReplication(packet);
            }
        }
        catch (ActiveMQException e) {
            ActiveMQServerLogger.LOGGER.errorHandlingReplicationPacket((Exception)((Object)e), packet);
            response = new ActiveMQExceptionMessage(e);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorHandlingReplicationPacket(e, packet);
            response = new ActiveMQExceptionMessage((ActiveMQException)ActiveMQMessageBundle.BUNDLE.replicationUnhandledError(e));
        }
        this.channel.send((Packet)response);
    }

    private void handleFatalError(BackupReplicationStartFailedMessage packet) {
        ActiveMQServerLogger.LOGGER.errorStartingReplication(packet.getRegistrationProblem());
        this.server.stopTheServer(false);
    }

    private void handleLiveStopping(ReplicationLiveIsStoppingMessage packet) throws ActiveMQException {
        this.activation.remoteFailOver(packet.isFinalMessage());
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void start() throws Exception {
        block3: {
            Configuration config = this.server.getConfiguration();
            try {
                this.storageManager = this.server.getStorageManager();
                this.storageManager.start();
                this.server.getManagementService().setStorageManager(this.storageManager);
                this.journalsHolder.put(JournalStorageManager.JournalContent.BINDINGS, this.storageManager.getBindingsJournal());
                this.journalsHolder.put(JournalStorageManager.JournalContent.MESSAGES, this.storageManager.getMessageJournal());
                for (JournalStorageManager.JournalContent jc : EnumSet.allOf(JournalStorageManager.JournalContent.class)) {
                    this.filesReservedForSync.put(jc, new HashMap());
                    this.journalLoadInformation[jc.typeByte] = this.journalsHolder.get((Object)jc).loadSyncOnly(Journal.JournalState.SYNCING);
                }
                this.pageManager = new PagingManagerImpl(new PagingStoreFactoryNIO(this.storageManager, config.getPagingLocation(), config.getJournalBufferSize_NIO(), this.server.getScheduledPool(), this.server.getExecutorFactory(), config.isJournalSyncNonTransactional(), this.criticalErrorListener), this.server.getAddressSettingsRepository());
                this.pageManager.start();
                this.started = true;
            }
            catch (Exception e) {
                if (!this.server.isStarted()) break block3;
                throw e;
            }
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        for (ReplicatedLargeMessage replicatedLargeMessage : this.largeMessages.values()) {
            replicatedLargeMessage.releaseResources();
        }
        this.largeMessages.clear();
        for (Map.Entry entry : this.filesReservedForSync.entrySet()) {
            for (JournalSyncFile journalSyncFile : ((Map)entry.getValue()).values()) {
                journalSyncFile.close();
            }
        }
        this.filesReservedForSync.clear();
        if (this.journals != null) {
            for (Iterator<Object> iterator : this.journals) {
                if (!(iterator instanceof FileWrapperJournal)) continue;
                iterator.stop();
            }
        }
        for (ConcurrentMap concurrentMap : this.pageIndex.values()) {
            for (Page page : concurrentMap.values()) {
                try {
                    page.sync();
                    page.close();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorClosingPageOnReplication(e);
                }
            }
        }
        this.pageManager.stop();
        this.pageIndex.clear();
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await(30L, TimeUnit.SECONDS);
        this.storageManager.stop();
        this.started = false;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void compareJournalInformation(JournalLoadInformation[] journalInformation) throws ActiveMQException {
        if (!this.activation.isRemoteBackupUpToDate()) {
            throw ActiveMQMessageBundle.BUNDLE.journalsNotInSync();
        }
        if (this.journalLoadInformation == null || this.journalLoadInformation.length != journalInformation.length) {
            throw ActiveMQMessageBundle.BUNDLE.replicationTooManyJournals();
        }
        for (int i = 0; i < journalInformation.length; ++i) {
            if (journalInformation[i].equals((Object)this.journalLoadInformation[i])) continue;
            ActiveMQServerLogger.LOGGER.journalcomparisonMismatch(this.journalParametersToString(journalInformation));
            throw ActiveMQMessageBundle.BUNDLE.replicationTooManyJournals();
        }
    }

    public void setDeletePages(boolean deletePages) {
        this.deletePages = deletePages;
    }

    private String journalParametersToString(JournalLoadInformation[] journalInformation) {
        return "**********************************************************\nparameters:\nBindingsImpl = " + journalInformation[0] + "\n" + "Messaging = " + journalInformation[1] + "\n" + "**********************************************************" + "\n" + "Expected:" + "\n" + "BindingsImpl = " + this.journalLoadInformation[0] + "\n" + "Messaging = " + this.journalLoadInformation[1] + "\n" + "**********************************************************";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSynchronization(String liveID) throws Exception {
        for (JournalStorageManager.JournalContent jc : EnumSet.allOf(JournalStorageManager.JournalContent.class)) {
            Journal journal = this.journalsHolder.remove((Object)jc);
            journal.synchronizationLock();
            try {
                this.filesReservedForSync.remove((Object)jc);
                this.registerJournal(jc.typeByte, journal);
                journal.stop();
                journal.start();
                journal.loadSyncOnly(Journal.JournalState.SYNCING_UP_TO_DATE);
            }
            finally {
                journal.synchronizationUnlock();
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        for (Map.Entry entry : this.largeMessages.entrySet()) {
            ReplicatedLargeMessage lm = (ReplicatedLargeMessage)entry.getValue();
            if (!(lm instanceof LargeServerMessageInSync)) continue;
            LargeServerMessageInSync lmSync = (LargeServerMessageInSync)lm;
            lmSync.joinSyncedData(buffer);
        }
        this.journalsHolder = null;
        this.backupQuorum.liveIDSet(liveID);
        this.activation.setRemoteBackupUpToDate();
        ActiveMQServerLogger.LOGGER.backupServerSynched(this.server);
    }

    private synchronized void handleReplicationSynchronization(ReplicationSyncFileMessage msg) throws Exception {
        SequentialFile channel1;
        Long id = msg.getId();
        byte[] data = msg.getData();
        switch (msg.getFileType()) {
            case LARGE_MESSAGE: {
                ReplicatedLargeMessage largeMessage = this.lookupLargeMessage(id, false);
                if (!(largeMessage instanceof LargeServerMessageInSync)) {
                    ActiveMQServerLogger.LOGGER.largeMessageIncompatible();
                    return;
                }
                LargeServerMessageInSync largeMessageInSync = (LargeServerMessageInSync)largeMessage;
                channel1 = largeMessageInSync.getSyncFile();
                break;
            }
            case PAGE: {
                Page page = this.getPage(msg.getPageStore(), (int)msg.getId());
                channel1 = page.getFile();
                break;
            }
            case JOURNAL: {
                JournalSyncFile journalSyncFile = this.filesReservedForSync.get((Object)msg.getJournalContent()).get(id);
                FileChannel channel2 = journalSyncFile.getChannel();
                if (data == null) {
                    channel2.close();
                    return;
                }
                channel2.write(ByteBuffer.wrap(data));
                return;
            }
            default: {
                throw ActiveMQMessageBundle.BUNDLE.replicationUnhandledFileType(msg.getFileType());
            }
        }
        if (data == null) {
            channel1.close();
            return;
        }
        if (!channel1.isOpen()) {
            channel1.open();
        }
        channel1.writeDirect(ByteBuffer.wrap(data), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationResponseMessageV2 handleStartReplicationSynchronization(ReplicationStartSyncMessage packet) throws Exception {
        ReplicationResponseMessageV2 replicationResponseMessage = new ReplicationResponseMessageV2();
        if (this.activation.isRemoteBackupUpToDate()) {
            throw ActiveMQMessageBundle.BUNDLE.replicationBackupUpToDate();
        }
        ReplicationEndpoint replicationEndpoint = this;
        synchronized (replicationEndpoint) {
            if (!this.started) {
                return replicationResponseMessage;
            }
            if (packet.isSynchronizationFinished()) {
                this.finishSynchronization(packet.getNodeID());
                replicationResponseMessage.setSynchronizationIsFinishedAcknowledgement(true);
                return replicationResponseMessage;
            }
            switch (packet.getDataType()) {
                case LargeMessages: {
                    for (long msgID : packet.getFileIds()) {
                        this.createLargeMessage(msgID, true);
                    }
                    break;
                }
                case JournalBindings: 
                case JournalMessages: {
                    if (this.wantedFailBack && !packet.isServerToFailBack()) {
                        ActiveMQServerLogger.LOGGER.autoFailBackDenied();
                    }
                    JournalStorageManager.JournalContent journalContent = ReplicationStartSyncMessage.SyncDataType.getJournalContentType(packet.getDataType());
                    Journal journal = this.journalsHolder.get((Object)journalContent);
                    if (packet.getNodeID() != null) {
                        this.backupQuorum.liveIDSet(packet.getNodeID());
                    }
                    Map<Long, JournalSyncFile> mapToFill = this.filesReservedForSync.get((Object)journalContent);
                    for (Map.Entry entry : journal.createFilesForBackupSync(packet.getFileIds()).entrySet()) {
                        mapToFill.put((Long)entry.getKey(), new JournalSyncFile((JournalFile)entry.getValue()));
                    }
                    FileWrapperJournal syncJournal = new FileWrapperJournal(journal);
                    this.registerJournal(journalContent.typeByte, (Journal)syncJournal);
                    break;
                }
                default: {
                    throw ActiveMQMessageBundle.BUNDLE.replicationUnhandledDataType();
                }
            }
        }
        return replicationResponseMessage;
    }

    private void handleLargeMessageEnd(final ReplicationLargeMessageEndMessage packet) {
        final ReplicatedLargeMessage message = this.lookupLargeMessage(packet.getMessageId(), true);
        if (message != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        message.deleteFile();
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorDeletingLargeMessage(e, packet.getMessageId());
                    }
                }
            });
        }
    }

    private void handleLargeMessageWrite(ReplicationLargeMessageWriteMessage packet) throws Exception {
        ReplicatedLargeMessage message = this.lookupLargeMessage(packet.getMessageId(), false);
        if (message != null) {
            message.addBytes(packet.getBody());
        }
    }

    private ReplicatedLargeMessage lookupLargeMessage(long messageId, boolean delete) {
        ReplicatedLargeMessage message;
        if (delete) {
            message = (ReplicatedLargeMessage)this.largeMessages.remove(messageId);
        } else {
            message = (ReplicatedLargeMessage)this.largeMessages.get(messageId);
            if (message == null) {
                ActiveMQServerLogger.LOGGER.largeMessageNotAvailable(messageId);
            }
        }
        return message;
    }

    private void handleLargeMessageBegin(ReplicationLargeMessageBeginMessage packet) {
        long id = packet.getMessageId();
        this.createLargeMessage(id, false);
        ActiveMQServerLogger.LOGGER.trace("Receiving Large Message " + id + " on backup");
    }

    private void createLargeMessage(long id, boolean liveToBackupSync) {
        ReplicatedLargeMessage msg = liveToBackupSync ? new LargeServerMessageInSync(this.storageManager) : this.storageManager.createLargeMessage();
        msg.setDurable(true);
        msg.setMessageID(id);
        this.largeMessages.put(id, msg);
    }

    private void handleCommitRollback(ReplicationCommitMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        if (packet.isRollback()) {
            journalToUse.appendRollbackRecord(packet.getTxId(), false);
        } else {
            journalToUse.appendCommitRecord(packet.getTxId(), false);
        }
    }

    private void handlePrepare(ReplicationPrepareMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        journalToUse.appendPrepareRecord(packet.getTxId(), packet.getRecordData(), false);
    }

    private void handleAppendDeleteTX(ReplicationDeleteTXMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        journalToUse.appendDeleteRecordTransactional(packet.getTxId(), packet.getId(), packet.getRecordData());
    }

    private void handleAppendDelete(ReplicationDeleteMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        journalToUse.appendDeleteRecord(packet.getId(), false);
    }

    private void handleAppendAddTXRecord(ReplicationAddTXMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        if (packet.getOperation() == ReplicationManager.ADD_OPERATION_TYPE.UPDATE) {
            journalToUse.appendUpdateRecordTransactional(packet.getTxId(), packet.getId(), packet.getRecordType(), packet.getRecordData());
        } else {
            journalToUse.appendAddRecordTransactional(packet.getTxId(), packet.getId(), packet.getRecordType(), packet.getRecordData());
        }
    }

    private void handleAppendAddRecord(ReplicationAddMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        if (packet.getRecord() == ReplicationManager.ADD_OPERATION_TYPE.UPDATE) {
            if (trace) {
                ActiveMQServerLogger.LOGGER.trace("Endpoint appendUpdate id = " + packet.getId());
            }
            journalToUse.appendUpdateRecord(packet.getId(), packet.getJournalRecordType(), packet.getRecordData(), false);
        } else {
            if (trace) {
                ActiveMQServerLogger.LOGGER.trace("Endpoint append id = " + packet.getId());
            }
            journalToUse.appendAddRecord(packet.getId(), packet.getJournalRecordType(), packet.getRecordData(), false);
        }
    }

    private void handlePageEvent(ReplicationPageEventMessage packet) throws Exception {
        ConcurrentMap<Integer, Page> pages = this.getPageMap(packet.getStoreName());
        Page page = (Page)pages.remove(packet.getPageNumber());
        if (page == null) {
            page = this.getPage(packet.getStoreName(), packet.getPageNumber());
        }
        if (page != null) {
            if (packet.isDelete()) {
                if (this.deletePages) {
                    page.delete(null);
                }
            } else {
                page.close();
            }
        }
    }

    private void handlePageWrite(ReplicationPageWriteMessage packet) throws Exception {
        PagedMessage pgdMessage = packet.getPagedMessage();
        pgdMessage.initMessage(this.storageManager);
        ServerMessage msg = pgdMessage.getMessage();
        Page page = this.getPage(msg.getAddress(), packet.getPageNumber());
        page.write(pgdMessage);
    }

    private ConcurrentMap<Integer, Page> getPageMap(SimpleString storeName) {
        ConcurrentMap mapResult;
        ConcurrentMap resultIndex = (ConcurrentHashMap)this.pageIndex.get(storeName);
        if (resultIndex == null && (mapResult = (ConcurrentMap)this.pageIndex.putIfAbsent(storeName, resultIndex = new ConcurrentHashMap())) != null) {
            resultIndex = mapResult;
        }
        return resultIndex;
    }

    private Page getPage(SimpleString storeName, int pageId) throws Exception {
        ConcurrentMap<Integer, Page> map = this.getPageMap(storeName);
        Page page = (Page)map.get(pageId);
        if (page == null) {
            page = this.newPage(pageId, storeName, map);
        }
        return page;
    }

    private synchronized Page newPage(int pageId, SimpleString storeName, ConcurrentMap<Integer, Page> map) throws Exception {
        Page page = (Page)map.get(pageId);
        if (page == null) {
            page = this.pageManager.getPageStore(storeName).createPage(pageId);
            page.open();
            map.put(pageId, page);
        }
        return page;
    }

    private Journal getJournal(byte journalID) {
        return this.journals[journalID];
    }

    public synchronized void setBackupQuorum(SharedNothingBackupQuorum backupQuorum) {
        this.backupQuorum = backupQuorum;
    }

    public void setExecutor(Executor executor2) {
        this.executor = executor2;
    }

    public static final class JournalSyncFile {
        private FileChannel channel;
        private final File file;
        private FileOutputStream fos;

        public JournalSyncFile(JournalFile jFile) throws Exception {
            SequentialFile seqFile = jFile.getFile();
            this.file = seqFile.getJavaFile();
            seqFile.close();
        }

        synchronized FileChannel getChannel() throws Exception {
            if (this.channel == null) {
                this.fos = new FileOutputStream(this.file);
                this.channel = this.fos.getChannel();
            }
            return this.channel;
        }

        synchronized void close() throws IOException {
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.channel != null) {
                this.channel.close();
            }
        }

        public String toString() {
            return "JournalSyncFile(file=" + this.file.getAbsolutePath() + ")";
        }
    }
}

