/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;

public final class ActiveMQServers {
    private ActiveMQServers() {
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, boolean enablePersistence) {
        ActiveMQSecurityManagerImpl securityManager = new ActiveMQSecurityManagerImpl();
        ActiveMQServer server = ActiveMQServers.newActiveMQServer(config, ManagementFactory.getPlatformMBeanServer(), securityManager, enablePersistence);
        return server;
    }

    public static ActiveMQServer newActiveMQServer(Configuration config) {
        return ActiveMQServers.newActiveMQServer(config, config.isPersistenceEnabled());
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, MBeanServer mbeanServer, boolean enablePersistence) {
        ActiveMQSecurityManagerImpl securityManager = new ActiveMQSecurityManagerImpl();
        ActiveMQServer server = ActiveMQServers.newActiveMQServer(config, mbeanServer, securityManager, enablePersistence);
        return server;
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, MBeanServer mbeanServer) {
        return ActiveMQServers.newActiveMQServer(config, mbeanServer, true);
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager) {
        ActiveMQServer server = ActiveMQServers.newActiveMQServer(config, mbeanServer, securityManager, true);
        return server;
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, boolean enablePersistence) {
        config.setPersistenceEnabled(enablePersistence);
        ActiveMQServerImpl server = new ActiveMQServerImpl(config, mbeanServer, securityManager);
        return server;
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, String defUser, String defPass) {
        ActiveMQSecurityManagerImpl securityManager = new ActiveMQSecurityManagerImpl();
        securityManager.getConfiguration().addUser(defUser, defPass);
        ActiveMQServer server = ActiveMQServers.newActiveMQServer(config, ManagementFactory.getPlatformMBeanServer(), securityManager, config.isPersistenceEnabled());
        return server;
    }

    public static ActiveMQServer newActiveMQServer(Configuration config, MBeanServer mbeanServer, boolean enablePersistence, String user, String password) {
        ActiveMQSecurityManagerImpl securityManager = new ActiveMQSecurityManagerImpl();
        securityManager.getConfiguration().addUser(user, password);
        ActiveMQServer server = ActiveMQServers.newActiveMQServer(config, mbeanServer, securityManager, enablePersistence);
        return server;
    }
}

