/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class RegistryBuilder<K, V>
implements Builder<Registry<K, V>>,
Service<Registry<K, V>> {
    private final InjectedValue<RegistryFactory> factory = new InjectedValue();
    private final InjectedValue<RegistryEntryProvider> provider = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile Registry<K, V> registry;

    public RegistryBuilder(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return CacheGroupServiceName.REGISTRY.getServiceName(this.containerName, this.cacheName);
    }

    public ServiceBuilder<Registry<K, V>> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).addDependency(CacheGroupServiceName.REGISTRY_FACTORY.getServiceName(this.containerName, this.cacheName), RegistryFactory.class, this.factory).addDependency(CacheGroupServiceName.REGISTRY_ENTRY.getServiceName(this.containerName, this.cacheName), RegistryEntryProvider.class, this.provider).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Registry<K, V> getValue() {
        return this.registry;
    }

    public void start(StartContext context) {
        RegistryFactory factory = (RegistryFactory)this.factory.getValue();
        RegistryEntryProvider provider = (RegistryEntryProvider)this.provider.getValue();
        this.registry = factory.createRegistry(provider);
    }

    public void stop(StopContext context) {
        this.registry.close();
    }
}

