/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;

public class ExternalizerObjectTable
implements ObjectTable {
    private final Externalizer<?>[] externalizers;
    private final Map<Class<?>, ObjectTable.Writer> writers = new IdentityHashMap();
    final Externalizer<Integer> indexExternalizer;

    public ExternalizerObjectTable(ClassLoader loader) {
        this(IndexExternalizer.VARIABLE, (Externalizer[])StreamSupport.stream(ServiceLoader.load(Externalizer.class, loader).spliterator(), false).toArray(Externalizer[]::new));
    }

    public ExternalizerObjectTable(Externalizer<Integer> indexExternalizer, Externalizer<?> ... externalizers) {
        this.indexExternalizer = indexExternalizer;
        this.externalizers = externalizers;
        for (int i = 0; i < externalizers.length; ++i) {
            final Externalizer<?> externalizer = externalizers[i];
            final int index = i;
            Class targetClass = externalizer.getTargetClass();
            if (this.writers.containsKey(targetClass)) continue;
            ObjectTable.Writer writer = new ObjectTable.Writer(){

                public void writeObject(Marshaller marshaller, Object object) throws IOException {
                    ExternalizerObjectTable.this.indexExternalizer.writeObject((ObjectOutput)marshaller, (Object)index);
                    externalizer.writeObject((ObjectOutput)marshaller, object);
                }
            };
            this.writers.put(targetClass, writer);
        }
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        return this.writers.get(object.getClass());
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int index = (Integer)this.indexExternalizer.readObject((ObjectInput)unmarshaller);
        if (index >= this.externalizers.length) {
            throw new IllegalStateException();
        }
        return this.externalizers[index].readObject((ObjectInput)unmarshaller);
    }
}

