/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class EJBMethodPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    private transient String methodName;
    private transient String methodInterface;
    private transient String methodSig;

    public EJBMethodPermission(String name, String actions) {
        super(name);
        this.parseMethodSpec(actions);
    }

    public EJBMethodPermission(String ejbName, String methodInterface, Method method) {
        this(ejbName, method.getName(), methodInterface, EJBMethodPermission.convertParameters(method.getParameterTypes()));
    }

    public EJBMethodPermission(String ejbName, String methodName, String methodInterface, String[] methodParams) {
        super(ejbName);
        this.methodInterface = methodInterface;
        this.methodName = methodName;
        if (methodParams == null) {
            this.methodSig = null;
        } else {
            StringBuffer tmp = new StringBuffer();
            for (String methodParam : methodParams) {
                tmp.append(methodParam);
                tmp.append(',');
            }
            if (tmp.length() > 0) {
                tmp.setLength(tmp.length() - 1);
            }
            this.methodSig = tmp.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        boolean equals = false;
        if (o == null || !(o instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission perm = (EJBMethodPermission)o;
        equals = this.getName().equals(perm.getName());
        if (equals) {
            if (this.methodName != null) {
                if (perm.methodName == null) {
                    return false;
                }
                if (!this.methodName.equals(perm.methodName)) {
                    return false;
                }
            } else if (perm.methodName != null) {
                return false;
            }
            boolean bl = equals = this.methodInterface != perm.methodInterface;
            if (!equals && this.methodInterface != null) {
                equals = this.methodInterface.equals(perm.methodInterface);
            }
            if (!equals) {
                return false;
            }
            equals = this.methodSig != null ? perm.methodSig != null && this.methodSig.equals(perm.methodSig) : perm.methodSig == null;
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        if (this.methodName != null) {
            hashCode += this.methodName.hashCode();
        }
        if (this.methodInterface != null) {
            hashCode += this.methodInterface.hashCode();
        }
        if (this.methodSig != null) {
            hashCode += this.methodSig.hashCode();
        }
        return hashCode;
    }

    @Override
    public String getActions() {
        StringBuffer actions = new StringBuffer();
        if (this.methodName != null) {
            actions.append(this.methodName);
        }
        if (this.methodInterface != null) {
            actions.append(',');
            actions.append(this.methodInterface);
        } else if (this.methodSig != null) {
            actions.append(',');
        }
        if (this.methodSig != null) {
            actions.append(',');
            actions.append(this.methodSig);
        }
        String methodSpec = null;
        if (actions.length() > 0) {
            methodSpec = actions.toString();
        }
        return methodSpec;
    }

    @Override
    public boolean implies(Permission permission) {
        boolean implies = false;
        if (!(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission perm = (EJBMethodPermission)permission;
        implies = this.getName().equals(perm.getName());
        if (!implies) {
            return false;
        }
        implies = this.methodName != null ? this.methodName.equals(perm.methodName) : true;
        if (implies && this.methodInterface != null) {
            implies = this.methodInterface.equals(perm.methodInterface);
        }
        if (implies && this.methodSig != null) {
            implies = this.methodSig.equals(perm.methodSig);
        }
        return implies;
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        if (this.methodInterface != null) {
            tmp.append(this.methodInterface);
            tmp.append(':');
        } else {
            tmp.append("*:");
        }
        if (this.methodName != null) {
            tmp.append(this.methodName);
        } else {
            tmp.append("*");
        }
        tmp.append('(');
        if (this.methodSig != null) {
            tmp.append(this.methodSig);
        }
        tmp.append(")]");
        return tmp.toString();
    }

    private static String[] convertParameters(Class<?>[] params) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (Class<?> c : params) {
            if (c.isArray()) {
                Class<?> subType;
                StringBuffer sb = new StringBuffer();
                sb.append(subType.getName());
                for (subType = c.getComponentType(); subType != null; subType = subType.getComponentType()) {
                    sb.append("[]");
                }
                tmp.add(sb.toString());
                continue;
            }
            tmp.add(c.getName());
        }
        String[] sig = new String[tmp.size()];
        tmp.toArray(sig);
        return sig;
    }

    private void parseMethodSpec(String methodSpec) {
        this.methodName = null;
        this.methodInterface = null;
        this.methodSig = null;
        if (methodSpec != null) {
            StringTokenizer tokenizer = new StringTokenizer(methodSpec, ",", true);
            if (tokenizer.hasMoreTokens()) {
                this.methodName = tokenizer.nextToken();
                if (this.methodName.equals(",")) {
                    this.methodName = null;
                }
            }
            if (tokenizer.hasMoreTokens()) {
                this.methodInterface = tokenizer.nextToken();
                if (this.methodName != null && this.methodInterface.equals(",")) {
                    this.methodInterface = tokenizer.nextToken();
                }
                if (this.methodInterface.equals(",")) {
                    this.methodInterface = null;
                    this.methodSig = "";
                }
            }
            if (tokenizer.hasMoreTokens()) {
                if (this.methodInterface != null) {
                    tokenizer.nextToken();
                }
                StringBuffer tmp = new StringBuffer();
                while (tokenizer.hasMoreTokens()) {
                    tmp.append(tokenizer.nextToken());
                }
                this.methodSig = tmp.toString();
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String actions = (String)fields.get("actions", null);
        this.parseMethodSpec(actions);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("actions", this.getActions());
        oos.writeFields();
    }
}

