/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.event.STSCancelFailureEvent;
import org.apache.cxf.sts.event.STSCancelSuccessEvent;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestRequirements;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.canceller.TokenCanceller;
import org.apache.cxf.sts.token.canceller.TokenCancellerParameters;
import org.apache.cxf.sts.token.canceller.TokenCancellerResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedTokenCancelledType;
import org.apache.cxf.ws.security.sts.provider.operation.CancelOperation;
import org.apache.wss4j.common.ext.WSSecurityException;

public class TokenCancelOperation
extends AbstractOperation
implements CancelOperation {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenCancelOperation.class);
    private List<TokenCanceller> tokencancellers = new ArrayList<TokenCanceller>();

    public void setTokenCancellers(List<TokenCanceller> tokenCancellerList) {
        this.tokencancellers = tokenCancellerList;
    }

    public List<TokenCanceller> getTokenCancellers() {
        return this.tokencancellers;
    }

    public RequestSecurityTokenResponseType cancel(RequestSecurityTokenType request, WebServiceContext context) {
        long start = System.currentTimeMillis();
        TokenCancellerParameters cancellerParameters = new TokenCancellerParameters();
        try {
            RequestRequirements requestRequirements = this.parseRequest(request, context);
            KeyRequirements keyRequirements = requestRequirements.getKeyRequirements();
            TokenRequirements tokenRequirements = requestRequirements.getTokenRequirements();
            cancellerParameters.setStsProperties(this.stsProperties);
            cancellerParameters.setPrincipal(context.getUserPrincipal());
            cancellerParameters.setWebServiceContext(context);
            cancellerParameters.setTokenStore(this.getTokenStore());
            cancellerParameters.setKeyRequirements(keyRequirements);
            cancellerParameters.setTokenRequirements(tokenRequirements);
            ReceivedToken cancelTarget = tokenRequirements.getCancelTarget();
            if (cancelTarget == null || cancelTarget.getToken() == null) {
                throw new STSException("No element presented for cancellation", STSException.INVALID_REQUEST);
            }
            cancellerParameters.setToken(cancelTarget);
            if (tokenRequirements.getTokenType() == null) {
                tokenRequirements.setTokenType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status");
                LOG.fine("Received TokenType is null, falling back to default token type: http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status");
            }
            TokenCancellerResponse tokenResponse = null;
            for (TokenCanceller tokenCanceller : this.tokencancellers) {
                if (!tokenCanceller.canHandleToken(cancelTarget)) continue;
                try {
                    tokenResponse = tokenCanceller.cancelToken(cancellerParameters);
                    break;
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw new STSException("Error while cancelling a token", (Throwable)ex, STSException.REQUEST_FAILED);
                }
            }
            if (tokenResponse == null || tokenResponse.getToken() == null) {
                LOG.fine("No Token Canceller has been found that can handle this token");
                throw new STSException("No token canceller found for requested token type: " + tokenRequirements.getTokenType(), STSException.REQUEST_FAILED);
            }
            if (tokenResponse.getToken().getState() != ReceivedToken.STATE.CANCELLED) {
                LOG.log(Level.WARNING, "Token cancellation failed.");
                throw new STSException("Token cancellation failed.");
            }
            try {
                RequestSecurityTokenResponseType response = this.createResponse(tokenRequirements);
                STSCancelSuccessEvent event = new STSCancelSuccessEvent(cancellerParameters, System.currentTimeMillis() - start);
                this.publishEvent(event);
                return response;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in creating the response", ex, STSException.REQUEST_FAILED);
            }
        }
        catch (RuntimeException ex) {
            STSCancelFailureEvent event = new STSCancelFailureEvent(cancellerParameters, System.currentTimeMillis() - start, (Exception)ex);
            this.publishEvent(event);
            throw ex;
        }
    }

    private RequestSecurityTokenResponseType createResponse(TokenRequirements tokenRequirements) throws WSSecurityException {
        RequestSecurityTokenResponseType response = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseType();
        String context = tokenRequirements.getContext();
        if (context != null) {
            response.setContext(context);
        }
        RequestedTokenCancelledType cancelType = QNameConstants.WS_TRUST_FACTORY.createRequestedTokenCancelledType();
        JAXBElement cancel = QNameConstants.WS_TRUST_FACTORY.createRequestedTokenCancelled(cancelType);
        response.getAny().add(cancel);
        return response;
    }
}

