/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client.ejb;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.IdentityEJBClientContextSelector;
import org.jboss.ejb.client.NamedEJBClientContextIdentifier;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.RemoteContext;
import org.jboss.naming.remote.client.ejb.EJBClientHandler;
import org.jboss.remoting3.Connection;

public class RemoteNamingStoreEJBClientHandler
implements EJBClientHandler {
    private static final Logger logger = Logger.getLogger(RemoteNamingStoreEJBClientHandler.class);
    private static final String EJB_CLIENT_CONTEXT_NAME_PREFIX = "RemoteNamingEJBClientContext$";
    private static final AtomicLong nextEJBClientContextNumber = new AtomicLong();
    private final EJBClientContextIdentifier ejbClientContextIdentifier;
    private final EJBClientContext ejbClientContext;

    public static RemoteNamingStoreEJBClientHandler setupEJBClientContext(List<RemoteContext.CloseTask> closeTasks) {
        EJBClientContext ejbClientContext = EJBClientContext.create();
        String ejbClientContextName = EJB_CLIENT_CONTEXT_NAME_PREFIX + nextEJBClientContextNumber.addAndGet(1L);
        NamedEJBClientContextIdentifier ejbClientContextIdentifier = new NamedEJBClientContextIdentifier(ejbClientContextName);
        RemoteNamingStoreEJBClientHandler.registerEJBClientContextWithSelector(ejbClientContextIdentifier, ejbClientContext);
        if (closeTasks != null) {
            closeTasks.add(new RemoteNamingEJBClientContextCloseTask(ejbClientContext));
        }
        return new RemoteNamingStoreEJBClientHandler(ejbClientContextIdentifier, ejbClientContext);
    }

    private RemoteNamingStoreEJBClientHandler(EJBClientContextIdentifier ejbClientContextIdentifier, EJBClientContext ejbClientContext) {
        this.ejbClientContext = ejbClientContext;
        this.ejbClientContextIdentifier = ejbClientContextIdentifier;
    }

    @Override
    public void associate(Connection connection) {
        this.ejbClientContext.registerConnection(connection);
    }

    @Override
    public Object handleLookupReturnInstance(Object instance) {
        if (instance == null) {
            return null;
        }
        if (!EJBClient.isEJBProxy(instance)) {
            return instance;
        }
        EJBLocator<Object> ejbLocator = EJBClient.getLocatorFor(instance);
        return EJBClient.createProxy(ejbLocator, this.ejbClientContextIdentifier);
    }

    private static void registerEJBClientContextWithSelector(EJBClientContextIdentifier identifier, EJBClientContext ejbClientContext) {
        ContextSelector<EJBClientContext> currentSelector = EJBClientContext.getSelector();
        if (!(currentSelector instanceof IdentityEJBClientContextSelector)) {
            logger.info("Cannot create a scoped EJB client context for JNDI naming context since the current EJB client context selector can't handle scoped contexts");
        } else {
            ((IdentityEJBClientContextSelector)currentSelector).registerContext(identifier, ejbClientContext);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RemoteNamingStoreEJBClientHandler)) {
            return false;
        }
        RemoteNamingStoreEJBClientHandler that = (RemoteNamingStoreEJBClientHandler)obj;
        return this.ejbClientContextIdentifier.equals(that.ejbClientContextIdentifier) && this.ejbClientContext.equals(that.ejbClientContext);
    }

    private static class RemoteNamingEJBClientContextCloseTask
    implements RemoteContext.CloseTask {
        private EJBClientContext ejbClientContext;

        private RemoteNamingEJBClientContextCloseTask(EJBClientContext clientContext) {
            this.ejbClientContext = clientContext;
        }

        @Override
        public void close(boolean isFinalize) {
            try {
                this.ejbClientContext.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Failed to close EJB client context " + this.ejbClientContext), e);
            }
        }
    }
}

